/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MemoryUsagePanel
extends JPanel {
    private static final int MEMORY_UPDATE_TIME = 2000;
    private JLabel _usedMemLabel;
    private JLabel _freeMemLabel;
    private JLabel _totalMemLabel;
    private JLabel _maxUsedMemLabel;
    private long _maxUsedMem;

    public MemoryUsagePanel() {
        this(2000);
    }

    public MemoryUsagePanel(int updateTime) {
        super(new BorderLayout());
        JPanel sub = new JPanel(new GridLayout(0, 2, 1, 1));
        sub.add(new JLabel("used:  ", 4));
        this._usedMemLabel = new JLabel();
        sub.add(this._usedMemLabel);
        sub.add(new JLabel("free:  ", 4));
        this._freeMemLabel = new JLabel();
        sub.add(this._freeMemLabel);
        sub.add(new JLabel("TOTAL:  ", 4));
        this._totalMemLabel = new JLabel();
        sub.add(this._totalMemLabel);
        sub.add(new JLabel("max. used:  ", 4));
        this._maxUsedMemLabel = new JLabel();
        sub.add(this._maxUsedMemLabel);
        this.add("North", sub);
        JButton col = new JButton("Collect!");
        col.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
                MemoryUsagePanel.this._maxUsedMem = 0L;
                MemoryUsagePanel.this.updateMemoryDisplay();
            }
        });
        col.setToolTipText("Invokes the garbage collector and resets max.used");
        this.add("South", col);
        if (updateTime > 0) {
            new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MemoryUsagePanel.this.updateMemoryDisplay();
                }
            }).start();
        }
    }

    private static String getString(long size) {
        if (size > 1000L) {
            String prefix = MemoryUsagePanel.getString(size / 1000L);
            long remainder = size % 1000L;
            if (remainder > 100L) {
                return prefix + "," + remainder;
            }
            if (remainder > 10L) {
                return prefix + ",0" + remainder;
            }
            return prefix + ",00" + remainder;
        }
        return Long.toString(size);
    }

    private void updateMemoryDisplay() {
        Runtime rt = Runtime.getRuntime();
        long freeMem = rt.freeMemory();
        long totalMem = rt.totalMemory();
        long usedMem = totalMem - freeMem;
        this._usedMemLabel.setText(MemoryUsagePanel.getString(usedMem));
        this._freeMemLabel.setText(MemoryUsagePanel.getString(freeMem));
        this._totalMemLabel.setText(MemoryUsagePanel.getString(totalMem));
        if (usedMem > this._maxUsedMem) {
            this._maxUsedMem = usedMem;
            this._maxUsedMemLabel.setText(MemoryUsagePanel.getString(this._maxUsedMem));
        }
    }
}

