/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.AnyMessageDebugListener;
import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.DebugConstants;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

class DebugMessageCook
implements AnyMessageDebugListener,
DebugConstants {
    private static final boolean THROW_ASSERTION_EXCEPTION = true;
    private static final boolean STOP_ON_FATAL_ERRORS = true;
    private static final boolean EMPTY_THROW_ASSERTION = false;
    private static final int EMPTY_FATAL_RETURN = 0;
    private static final String HEAD_TRACE = "TRACE";
    private static final String HEAD_MESSAGE = "MESSAGE";
    private static final String HEAD_WARNING = "WARNING";
    private static final String HEAD_ERROR = "ERROR";
    private static final String HEAD_FATAL = "FATAL ERROR";
    private static final String HEAD_LOG = "LOGGING";
    private static final String HEAD_ASSERTION = "ASSERTION FAILED";
    private LinkedList _list = new LinkedList();

    DebugMessageCook() {
    }

    public void addListener(CookedMessageDebugListener listener) {
        this._list.add(new ListenerData(listener, true, true));
    }

    public void addListener(CookedMessageDebugListener listener, boolean stopOnFatalErrors, boolean throwAssertionException) {
        this._list.add(new ListenerData(listener, stopOnFatalErrors, throwAssertionException));
    }

    public void removeListener(CookedMessageDebugListener listener) {
        Iterator it = this._list.iterator();
        while (it.hasNext()) {
            ListenerData data = (ListenerData)it.next();
            if (data.listener != listener) continue;
            it.remove();
            break;
        }
    }

    private static String getFormatted(String head, String msg) {
        StringBuffer compile = new StringBuffer();
        compile.append(DateFormat.getDateTimeInstance().format(new Date())).append('\t').append(head).append(":\n");
        int lastIndex = 0;
        int index = msg.indexOf(10);
        while (index != -1) {
            compile.append('\t').append(msg.substring(lastIndex, index + 1));
            lastIndex = index + 1;
            index = msg.indexOf(10, lastIndex);
        }
        compile.append('\t').append(msg.substring(lastIndex)).append('\n');
        return compile.toString();
    }

    private void distribute(int msgType, String cooked, String pos) {
        Iterator it = this._list.iterator();
        while (it.hasNext()) {
            ((ListenerData)it.next()).listener.receiveCookedMessage(msgType, cooked, pos);
        }
    }

    private int distributeFatal(String cooked, String pos) {
        boolean exit = false;
        for (ListenerData data : this._list) {
            data.listener.receiveCookedMessage(4, cooked, pos);
            if (exit || !data.stopOnFatalErrors) continue;
            exit = true;
        }
        return exit ? 1 : 0;
    }

    private boolean distributeFailedAssertion(String cooked, String pos) {
        boolean dothrow = false;
        for (ListenerData data : this._list) {
            data.listener.receiveCookedMessage(6, cooked, pos);
            if (dothrow || !data.stopOnFatalErrors) continue;
            dothrow = true;
        }
        return dothrow;
    }

    public void receiveTraceMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            this.distribute(0, DebugMessageCook.getFormatted(HEAD_TRACE, msg), pos);
        }
    }

    public void receiveStandardMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            this.distribute(1, DebugMessageCook.getFormatted(HEAD_MESSAGE, msg), pos);
        }
    }

    public void receiveWarningMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            this.distribute(2, DebugMessageCook.getFormatted(HEAD_WARNING, msg), pos);
        }
    }

    public void receiveErrorMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            this.distribute(3, DebugMessageCook.getFormatted(HEAD_ERROR, msg), pos);
        }
    }

    public void receiveLogMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            this.distribute(5, DebugMessageCook.getFormatted(HEAD_LOG, msg), pos);
        }
    }

    public int receiveFatalMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            return this.distributeFatal(DebugMessageCook.getFormatted(HEAD_FATAL, msg), pos);
        }
        return 0;
    }

    public boolean receiveFailedAssertionMessage(String msg, String pos) {
        if (!this._list.isEmpty()) {
            return this.distributeFailedAssertion(DebugMessageCook.getFormatted(HEAD_ASSERTION, msg), pos);
        }
        return false;
    }

    public static String cookedPosition(String pos) {
        return "\t[at " + pos + "]\n";
    }

    static class ListenerData {
        CookedMessageDebugListener listener;
        boolean stopOnFatalErrors;
        boolean throwAssertionException;

        ListenerData(CookedMessageDebugListener listener, boolean stopOnFatalErrors, boolean throwAssertionException) throws NullPointerException {
            if (listener == null) {
                throw new NullPointerException();
            }
            this.listener = listener;
            this.stopOnFatalErrors = stopOnFatalErrors;
            this.throwAssertionException = throwAssertionException;
        }
    }
}

