/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.EventQueueExceptionListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.LinkedList;

class EventQueueExceptionWrapper
extends EventQueue {
    private Collection listeners = new LinkedList();

    public EventQueueExceptionWrapper() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    protected void dispatchEvent(AWTEvent event) {
        try {
            super.dispatchEvent(event);
        }
        catch (Throwable t) {
            for (EventQueueExceptionListener listener : this.listeners) {
                listener.exceptionOccured(event, t);
            }
        }
    }

    public void addEventQueueExceptionListener(EventQueueExceptionListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventQueueExceptionListener(EventQueueExceptionListener listener) {
        this.listeners.remove(listener);
    }
}

