/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.gimmicks.swing.State;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class StateButton
extends JToggleButton
implements PropertyChangeListener,
ItemListener {
    private State state;

    public StateButton(final State state) {
        String ttt;
        this.setModel(new JToggleButton.ToggleButtonModel(){

            public void setPressed(boolean b) {
                if (!state.isActivated() || b) {
                    super.setPressed(b);
                }
            }
        });
        this.state = state;
        Icon icon = (Icon)state.getValue("INACTIVE_ICON");
        if (icon != null) {
            this.setIcon(icon);
            icon = (Icon)state.getValue("ACTIVE_ICON");
            if (icon != null) {
                this.setSelectedIcon(icon);
            }
            if ((icon = (Icon)state.getValue("DISABLED_ICON")) != null) {
                this.setDisabledIcon(icon);
                this.setDisabledSelectedIcon(icon);
            }
        } else {
            this.setText((String)state.getValue("LABEL_TEXT"));
        }
        if ((ttt = (String)state.getValue("TOOLTIP_TEXT")) != null) {
            this.setToolTipText(ttt);
        }
        this.setEnabled(state.isEnabled());
        this.setSelected(state.isActivated());
        this.addItemListener(this);
        state.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("ACTIVATION".equals(property)) {
            boolean state = (Boolean)evt.getNewValue();
            if (state != this.isSelected()) {
                this.setSelected(state);
            }
        } else if ("ENABLE".equals(property)) {
            boolean state = (Boolean)evt.getNewValue();
            if (state != this.isEnabled()) {
                this.setEnabled(state);
            }
        } else if ("ACTIVE_ICON".equals(property)) {
            Icon icon = (Icon)evt.getNewValue();
            if (!icon.equals(this.getSelectedIcon())) {
                this.setSelectedIcon(icon);
            }
        } else if ("DISABLED_ICON".equals(property)) {
            Icon icon = (Icon)evt.getNewValue();
            if (!icon.equals(this.getDisabledIcon())) {
                this.setDisabledIcon(icon);
                this.setDisabledSelectedIcon(icon);
            }
        } else if ("INACTIVE_ICON".equals(property)) {
            Icon icon = (Icon)evt.getNewValue();
            if (!icon.equals(this.getIcon())) {
                this.setIcon(icon);
            }
        } else if ("LABEL_TEXT".equals(property)) {
            String text = (String)evt.getNewValue();
            if (this.getIcon() == null) {
                this.setText(text);
            }
        } else if ("TOOLTIP_TEXT".equals(property)) {
            String text = (String)evt.getNewValue();
            this.setToolTipText(text);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.state.activate();
        }
    }
}

