/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.rammi.AbstractBasicFuturologist;
import de.caff.asteroid.rammi.Futurologist;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ThreadingFuturologist
extends AbstractBasicFuturologist
implements Runnable {
    private LinkedBlockingQueue<FrameInfo> incomingFrames = new LinkedBlockingQueue();
    private ConcurrentHashMap<Integer, Integer> asteroidHits = new ConcurrentHashMap();

    public void frameReceived(FrameInfo frame) {
        while (true) {
            try {
                this.incomingFrames.put(frame);
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    FrameInfo info;
                    FrameInfo next = this.incomingFrames.take();
                    do {
                        info = next;
                    } while ((next = this.incomingFrames.poll()) != null);
                    this.handleFrameInfo(info);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected void addHit(Integer astIdent, int frameCounter) {
        Integer currentCounter = this.asteroidHits.get(astIdent);
        if (currentCounter == null || currentCounter > frameCounter) {
            this.asteroidHits.put(astIdent, frameCounter);
        }
    }

    protected void forgetEverything() {
        this.asteroidHits.clear();
    }

    protected int getFramesTillDestroyed(Integer ident, FrameInfo frameInfo) {
        Integer hitFrame = this.asteroidHits.get(ident);
        if (hitFrame != null) {
            return hitFrame - frameInfo.getIndex();
        }
        return -1;
    }

    static Futurologist createBackgroundFuturologist() {
        ThreadingFuturologist f = new ThreadingFuturologist();
        new Thread(f).start();
        return f;
    }
}

