/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.DefaultScorer;
import de.caff.asteroid.rammi.SuicidePlayer;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Random;

public class SimulatedAnnealingPlayer
implements FrameListener {
    private static final int TESTS_PER_COEFF = 10;
    private static final double COOLING = 0.7;
    private static final int BEST_SURVIVERS = 6;
    static final int FRAMES_COUNT = 10800;
    private Communication com;
    private AsteroidPlayer asteroidPlayer;
    private SuicidePlayer suicidePlayer;
    private int startFrame;
    private Coeff[] coeffs = new Coeff[36];
    private double dangerFramesVar = 138.0;
    private double dangerScoreVar = 174.0;
    private double nearnessBaseVar = 762.0;
    private double rotationBaseVar = 2.0;
    private Random random = new Random();
    private int currentCoeff = 0;
    private Writer writer;

    public SimulatedAnnealingPlayer(Communication com) {
        try {
            this.writer = new FileWriter("sim.out");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.com = com;
        this.suicidePlayer = null;
        Arrays.fill(this.coeffs, new Coeff(this.dangerFramesVar, this.dangerScoreVar, this.nearnessBaseVar, this.rotationBaseVar));
        this.coeffs[1] = new Coeff(0.0, 0.0, 0.0, 0.0);
        for (int i = 2; i < 6; ++i) {
            this.coeffs[i] = new Coeff((double)(i == 2 ? 4 : 2) * this.random.nextDouble() * this.dangerFramesVar, (double)(i == 3 ? 4 : 2) * this.random.nextDouble() * this.dangerScoreVar, (double)(i == 4 ? 4 : 2) * this.random.nextDouble() * this.nearnessBaseVar, (double)(i == 5 ? 4 : 2) * this.random.nextDouble() * this.rotationBaseVar);
        }
        this.initializeCoeffs();
    }

    private void initializeCoeffs() {
        this.storeLine("dangerFramesVar=" + this.dangerFramesVar);
        this.storeLine("dangerScoreVar =" + this.dangerScoreVar);
        this.storeLine("nearnessBaseVar=" + this.nearnessBaseVar);
        this.storeLine("---------------------------------------------------");
        for (int c = 6; c < this.coeffs.length; ++c) {
            int base = c % 6;
            this.coeffs[c] = new Coeff(this.coeffs[base].getDangerFrames() + this.random.nextGaussian() * this.dangerFramesVar, this.coeffs[base].getDangerScore() + this.random.nextGaussian() * this.dangerScoreVar, this.coeffs[base].getNearnessBase() + this.random.nextGaussian() * this.nearnessBaseVar, this.coeffs[base].getRotationBase() + this.random.nextGaussian() * this.rotationBaseVar);
        }
        this.currentCoeff = 0;
        this.dangerFramesVar *= 0.7;
        this.dangerScoreVar *= 0.7;
        this.nearnessBaseVar *= 0.7;
    }

    private void storeResults() {
        Arrays.sort(this.coeffs);
        for (int c = 0; c < this.coeffs.length; ++c) {
            this.storeLine(String.format("%f: %f;%f;%f", this.coeffs[c].getAverageScore(), this.coeffs[c].getDangerFrames(), this.coeffs[c].getDangerScore(), this.coeffs[c].getNearnessBase()));
        }
        this.storeLine("===================================================");
    }

    private void storeLine(String line) {
        System.out.println(line);
        try {
            this.writer.append(line);
            this.writer.append("\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private AsteroidPlayer getNextPlayer() {
        while (this.currentCoeff < this.coeffs.length) {
            if (this.coeffs[this.currentCoeff].getCount() < 10) {
                return new AsteroidPlayer(this.com, new DefaultScorer(this.coeffs[this.currentCoeff].getDangerFrames(), this.coeffs[this.currentCoeff].getDangerScore(), this.coeffs[this.currentCoeff].getNearnessBase(), this.coeffs[this.currentCoeff].getRotationBase()));
            }
            ++this.currentCoeff;
        }
        this.storeResults();
        this.initializeCoeffs();
        return this.getNextPlayer();
    }

    public void frameReceived(FrameInfo frame) {
        if (frame.isGameEndDisplayed()) {
            if (this.asteroidPlayer != null) {
                this.com.removeFrameListener(this.asteroidPlayer);
                this.asteroidPlayer = null;
                this.coeffs[this.currentCoeff].addScore(frame.getScore());
                System.out.println("\tScore: " + frame.getScore());
            } else if (this.suicidePlayer != null) {
                this.com.removeFrameListener(this.suicidePlayer);
            }
        } else if (frame.isGameRunning()) {
            if (this.asteroidPlayer != null && frame.getIndex() - this.startFrame >= 10800) {
                this.com.removeFrameListener(this.asteroidPlayer);
                this.coeffs[this.currentCoeff].addScore(frame.getScore());
                System.out.println("\tScore: " + frame.getScore());
                this.asteroidPlayer = null;
                this.suicidePlayer = new SuicidePlayer(this.com);
                this.com.addFrameListener(this.suicidePlayer);
            }
        } else {
            this.startFrame = frame.getIndex();
            if (this.asteroidPlayer == null) {
                this.asteroidPlayer = this.getNextPlayer();
                this.com.addFrameListener(this.asteroidPlayer);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Coeff
    implements Comparable<Coeff> {
        private final double dangerFrames;
        private final double dangerScore;
        private final double nearnessBase;
        private final double rotationBase;
        private int score;
        private int count;

        Coeff(double dangerFrames, double dangerScore, double nearnessBase, double rotationBase) {
            this.dangerFrames = dangerFrames;
            this.dangerScore = dangerScore;
            this.nearnessBase = nearnessBase;
            this.rotationBase = rotationBase;
        }

        public void addScore(int score) {
            this.score += score;
            ++this.count;
        }

        public double getDangerFrames() {
            return this.dangerFrames;
        }

        public double getDangerScore() {
            return this.dangerScore;
        }

        public double getNearnessBase() {
            return this.nearnessBase;
        }

        public double getRotationBase() {
            return this.rotationBase;
        }

        public double getAverageScore() {
            return this.count == 0 ? 0.0 : (double)this.score / (double)this.count;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(Coeff o) {
            int here = (int)this.getAverageScore();
            int there = (int)o.getAverageScore();
            return there - here;
        }
    }
}

