/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.rammi.BulletLifetimeInformation;
import de.caff.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ShootingLaneDisplay
implements GameData,
DrawableProvider {
    private BulletLifetimeInformation bulletInfo;
    private BufferedImage[] images = new BufferedImage[256];

    public ShootingLaneDisplay(Color laneColor) {
        this(laneColor, laneColor);
    }

    public ShootingLaneDisplay(Color laneColorEven, Color laneColorOdd) {
        try {
            this.bulletInfo = BulletLifetimeInformation.getLifetimeInformation(8, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        laneColorEven = laneColorEven.getAlpha() < 256 ? laneColorEven : new Color(laneColorEven.getRed(), laneColorEven.getGreen(), laneColorEven.getBlue(), 128);
        laneColorOdd = laneColorOdd.getAlpha() < 256 ? laneColorOdd : new Color(laneColorOdd.getRed(), laneColorOdd.getGreen(), laneColorOdd.getBlue(), 128);
        for (int i = 0; i < 256; ++i) {
            this.images[i] = new BufferedImage(1024, 768, 2);
            ShootingLaneDisplay.fillImage(this.bulletInfo, this.images[i], (byte)i, laneColorEven, laneColorOdd);
        }
    }

    private static void fillImage(BulletLifetimeInformation bulletInfo, BufferedImage image, byte dirByte, Color laneColorEven, Color laneColorOdd) {
        if (bulletInfo != null) {
            int rgbEven = laneColorEven.getRGB();
            int rgbOdd = laneColorOdd.getRGB();
            for (int x = 0; x < 1024; ++x) {
                for (int y = 0; y < 768; ++y) {
                    BulletLifetimeInformation.BulletFrameInfo[] bulletInfos = bulletInfo.getHitBulletInfos(x - 512, 384 - y);
                    int rgb = 0;
                    for (BulletLifetimeInformation.BulletFrameInfo info : bulletInfos) {
                        if (info.getDirection() != dirByte) continue;
                        rgb = info.getFrame() % 2 == 0 ? rgbEven : rgbOdd;
                        break;
                    }
                    image.setRGB(x, y, rgb);
                }
            }
        }
    }

    private static void fillImageHitable(BulletLifetimeInformation bulletInfo, BufferedImage image, Color laneColor) {
        if (bulletInfo != null) {
            int rgb = laneColor.getRGB();
            for (int x = 0; x < 1024; ++x) {
                for (int y = 0; y < 768; ++y) {
                    BulletLifetimeInformation.BulletFrameInfo[] bulletInfos = bulletInfo.getHitBulletInfos(x - 512, 384 - y);
                    image.setRGB(x, y, bulletInfos.length > 0 ? rgb : 0);
                }
            }
        }
    }

    public void draw(Graphics2D g, FrameInfo frame) {
        BufferedImage image = this.images[Tools.byteToUnsigned(frame.getShootingDirectionLowLevel())];
        g.drawImage((Image)image, 0, 0, null);
    }

    private static void saveImage(RenderedImage image, String id) throws IOException {
        String name = String.format("shootlane-%s.png", id);
        System.out.println("Saving " + name + " ...");
        ImageIO.write(image, "PNG", new File(name));
        System.out.println("Done.");
    }

    public static void main(String[] args) throws IOException {
        BulletLifetimeInformation bulletInfo = BulletLifetimeInformation.getLifetimeInformation(8, 2);
        BufferedImage image = new BufferedImage(1024, 768, 2);
        if (args.length == 0) {
            ShootingLaneDisplay.fillImageHitable(bulletInfo, image, Color.red);
            ShootingLaneDisplay.saveImage(image, "HITABLE");
            for (int i = 0; i < 256; ++i) {
                ShootingLaneDisplay.fillImage(bulletInfo, image, (byte)i, Color.red, Color.blue);
                ShootingLaneDisplay.saveImage(image, String.format("%03d", i));
            }
        } else {
            for (String arg : args) {
                if ("HIT".equalsIgnoreCase(arg)) {
                    ShootingLaneDisplay.fillImageHitable(bulletInfo, image, Color.red);
                    ShootingLaneDisplay.saveImage(image, "HITABLE");
                    continue;
                }
                int id = Integer.parseInt(arg);
                ShootingLaneDisplay.fillImage(bulletInfo, image, (byte)id, Color.red, Color.blue);
                ShootingLaneDisplay.saveImage(image, String.format("%03d", id));
            }
        }
    }
}

