/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.rammi.HitAnalysis;
import de.caff.asteroid.rammi.ImprovedVelocityPreparer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public class HitAnalysisDisplay
extends JComponent {
    private static final int HIT_RADIUS = 2;
    private static final Color HIT_COLOR = Color.red;
    private static final Color MISS_COLOR = Color.green;
    private static final int MAX_SHOW_SIZE = 128;
    private static final Rectangle2D SHOW_BOX = new Rectangle2D.Double(-256.0, -256.0, 512.0, 512.0);
    private static final DataExtractor SMALL_ASTEROIDS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getSmallAsteroidsInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            for (Asteroid ast : info.getAsteroids()) {
                if (ast.getScore() != 100) continue;
                result.add(ast);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 8;
        }

        public String toString() {
            return "Small Asteroids";
        }
    };
    private static final DataExtractor MIDDLE_ASTEROIDS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getMiddleAsteroidsInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            for (Asteroid ast : info.getAsteroids()) {
                if (ast.getScore() != 50) continue;
                result.add(ast);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 16;
        }

        public String toString() {
            return "Middle Asteroids";
        }
    };
    private static final DataExtractor LARGE_ASTEROIDS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getLargeAsteroidsInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            for (Asteroid ast : info.getAsteroids()) {
                if (ast.getScore() != 20) continue;
                result.add(ast);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 32;
        }

        public String toString() {
            return "Large Asteroids";
        }
    };
    private static final DataExtractor SMALL_UFOS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getSmallUfosInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            Ufo ufo = info.getUfo();
            if (ufo != null && ufo.getScore() == 1000) {
                result.add(ufo);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 8;
        }

        public String toString() {
            return "Small Ufos";
        }
    };
    private static final DataExtractor LARGE_UFOS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getLargeUfosInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            Ufo ufo = info.getUfo();
            if (ufo != null && ufo.getScore() == 200) {
                result.add(ufo);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 16;
        }

        public String toString() {
            return "Large Ufos";
        }
    };
    private static final DataExtractor SHIPS_EXTRACTOR = new AbstractBasicDataExtractor(){

        @Override
        protected Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis hitAnalysis) {
            return hitAnalysis.getShipsInfo();
        }

        @Override
        protected Collection<MovingGameObject> getInterestingObjects(FrameInfo info) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            SpaceShip ship = info.getSpaceShip();
            if (ship != null) {
                result.add(ship);
            }
            return result;
        }

        @Override
        public int getSize() {
            return 13;
        }

        public String toString() {
            return "Ships";
        }
    };
    private DumpFile dumpFile;
    private HitAnalysis analysis;
    private HitAndMiss hitAndMiss;
    private JFrame frame;
    private DataExtractor extractor;
    private ShapePainter painter = new NullShapePainter();
    private int showSize = 64;
    private int deltaX = 0;
    private int deltaY = 0;
    private int deltaR = 0;

    static Shape createOctagon() {
        int size = 1;
        GeneralPath path = new GeneralPath();
        float factor = 2.0f;
        path.moveTo(size, (float)size / 2.0f);
        path.lineTo((float)size / 2.0f, size);
        path.lineTo((float)(-size) / 2.0f, size);
        path.lineTo(-size, (float)size / 2.0f);
        path.lineTo(-size, (float)(-size) / 2.0f);
        path.lineTo((float)(-size) / 2.0f, -size);
        path.lineTo((float)size / 2.0f, -size);
        path.lineTo(size, (float)(-size) / 2.0f);
        path.closePath();
        return path;
    }

    public HitAnalysisDisplay(JFrame frame, String dump) throws IOException {
        this.frame = frame;
        this.dumpFile = new DumpFile(dump);
        this.dumpFile.runPreparerDirectly(new ImprovedVelocityPreparer());
        this.analysis = new HitAnalysis();
        this.analysis.analyse(this.dumpFile.getInfos());
        this.setExtractor(SHIPS_EXTRACTOR);
        this.setPreferredSize(new Dimension(500, 500));
        final JPopupMenu popupMenu = new JPopupMenu("Select Objects");
        popupMenu.add(new AnalyseAction(this, SMALL_ASTEROIDS_EXTRACTOR));
        popupMenu.add(new AnalyseAction(this, MIDDLE_ASTEROIDS_EXTRACTOR));
        popupMenu.add(new AnalyseAction(this, LARGE_ASTEROIDS_EXTRACTOR));
        popupMenu.add(new AnalyseAction(this, SMALL_UFOS_EXTRACTOR));
        popupMenu.add(new AnalyseAction(this, LARGE_UFOS_EXTRACTOR));
        popupMenu.add(new AnalyseAction(this, SHIPS_EXTRACTOR));
        popupMenu.addSeparator();
        popupMenu.add(new ShowSizeAction(128));
        popupMenu.add(new ShowSizeAction(64));
        popupMenu.add(new ShowSizeAction(32));
        popupMenu.add(new ShowSizeAction(16));
        popupMenu.add(new ShowSizeAction(8));
        popupMenu.addSeparator();
        popupMenu.add(new ShapePainterAction("No Shape", new NullShapePainter()));
        popupMenu.add(new ShapePainterAction("Rectangle", new RectangularShapePainter()));
        popupMenu.add(new ShapePainterAction("Circle", new CircularShapePainter()));
        popupMenu.add(new ShapePainterAction("Octagon", new OctagonalShapePainter()));
        popupMenu.addSeparator();
        popupMenu.add(new DeltaAction("Shape left", -1, 0));
        popupMenu.add(new DeltaAction("Shape right", 1, 0));
        popupMenu.add(new DeltaAction("Shape up", 0, 1));
        popupMenu.add(new DeltaAction("Shape down", 0, -1));
        popupMenu.addSeparator();
        popupMenu.add(new ChangeSizeAction("Shrink Shape", -1));
        popupMenu.add(new ChangeSizeAction("Expand Shape", 1));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    return;
                }
                LinkedList<LineInfo> hits = new LinkedList<LineInfo>();
                Rectangle2D hitArea = new Rectangle2D.Double(e.getX() - 2, e.getY() - 2, 4.0, 4.0);
                int smaller = Math.min(HitAnalysisDisplay.this.getWidth(), HitAnalysisDisplay.this.getHeight());
                double scaling = smaller / (2 * HitAnalysisDisplay.this.showSize);
                AffineTransform backTrafo = AffineTransform.getScaleInstance(1.0 / scaling, -1.0 / scaling);
                backTrafo.concatenate(AffineTransform.getTranslateInstance(-HitAnalysisDisplay.this.getWidth() / 2, -HitAnalysisDisplay.this.getHeight() / 2));
                hitArea = backTrafo.createTransformedShape(hitArea).getBounds2D();
                for (LineInfo lineInfo : HitAnalysisDisplay.this.hitAndMiss.getHitLines()) {
                    if (!hitArea.intersectsLine(lineInfo.getLine())) continue;
                    hits.add(lineInfo);
                }
                for (LineInfo lineInfo : HitAnalysisDisplay.this.hitAndMiss.getMissLines()) {
                    if (!hitArea.intersectsLine(lineInfo.getLine())) continue;
                    hits.add(lineInfo);
                }
                for (LineInfo info : hits) {
                    System.out.println(info);
                }
                System.out.println();
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void setExtractor(DataExtractor extractor) {
        this.extractor = extractor;
        this.hitAndMiss = extractor.getHitAndMiss(this.dumpFile, this.analysis);
        this.refresh();
    }

    private void refresh() {
        this.refreshTitle();
        this.repaint();
    }

    private void refreshTitle() {
        this.frame.setTitle(String.format("Hit Analysis -- %s, [%dx%d], delta=[%d,%d;%d]", this.extractor.toString(), 2 * this.showSize, 2 * this.showSize, this.deltaX, this.deltaY, this.deltaR));
    }

    protected void paintComponent(Graphics g) {
        int smaller = Math.min(this.getWidth(), this.getHeight());
        if (smaller > 0) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Graphics2D g2 = (Graphics2D)g.create();
            double scaling = smaller / (2 * this.showSize);
            g2.translate(this.getWidth() / 2, this.getHeight() / 2);
            g2.scale(scaling, -scaling);
            g2.setStroke(new BasicStroke(0.0f));
            g2.setColor(HIT_COLOR);
            for (LineInfo lineInfo : this.hitAndMiss.getHitLines()) {
                g2.draw(lineInfo.getLine());
            }
            g2.setColor(MISS_COLOR);
            for (LineInfo lineInfo : this.hitAndMiss.getMissLines()) {
                g2.draw(lineInfo.getLine());
            }
            this.painter.drawShape(g2);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            JFrame frame = new JFrame("Hit Analysis");
            HitAnalysisDisplay display = new HitAnalysisDisplay(frame, args[0]);
            frame.getContentPane().add((Component)display, "Center");
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setVisible(true);
        }
    }

    private class DeltaAction
    extends AbstractAction {
        private final Point delta;

        DeltaAction(String name, int dx, int dy) {
            super(name);
            this.delta = new Point(dx, dy);
        }

        public void actionPerformed(ActionEvent e) {
            HitAnalysisDisplay.this.deltaX += this.delta.x;
            HitAnalysisDisplay.this.deltaY += this.delta.y;
            HitAnalysisDisplay.this.refresh();
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class ChangeSizeAction
    extends AbstractAction {
        private final int delta;

        private ChangeSizeAction(String name, int delta) {
            super(name);
            this.delta = delta;
        }

        public void actionPerformed(ActionEvent e) {
            HitAnalysisDisplay.this.deltaR += this.delta;
            if (HitAnalysisDisplay.this.deltaR < -4) {
                HitAnalysisDisplay.this.deltaR = -4;
            }
            HitAnalysisDisplay.this.refresh();
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class ShowSizeAction
    extends AbstractAction {
        private final int size;

        ShowSizeAction(int size) {
            super(String.format("%dx%d", 2 * size, 2 * size));
            this.size = size;
        }

        public void actionPerformed(ActionEvent e) {
            HitAnalysisDisplay.this.showSize = this.size;
            HitAnalysisDisplay.this.refresh();
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class ShapePainterAction
    extends AbstractAction {
        private final ShapePainter shapePainter;

        ShapePainterAction(String name, ShapePainter shapePainter) {
            super(name);
            this.shapePainter = shapePainter;
        }

        public void actionPerformed(ActionEvent e) {
            HitAnalysisDisplay.this.painter = this.shapePainter;
            HitAnalysisDisplay.this.refresh();
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private static class AnalyseAction
    extends AbstractAction {
        private final HitAnalysisDisplay display;
        private final DataExtractor dataExtractor;

        AnalyseAction(HitAnalysisDisplay display, DataExtractor dataExtractor) {
            super(dataExtractor.toString());
            this.display = display;
            this.dataExtractor = dataExtractor;
        }

        public void actionPerformed(ActionEvent e) {
            this.display.setExtractor(this.dataExtractor);
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractBasicDataExtractor
    implements DataExtractor {
        private AbstractBasicDataExtractor() {
        }

        @Override
        public HitAndMiss getHitAndMiss(DumpFile dumpFile, HitAnalysis hitAnalysis) {
            HitAndMiss result = new HitAndMiss();
            ArrayList<HitAnalysis.HitInfo> hitInfos = new ArrayList<HitAnalysis.HitInfo>(this.getHitInfos(hitAnalysis));
            HashMap<Integer, LinkedList<Integer>> excludedObjectsByFrame = new HashMap<Integer, LinkedList<Integer>>();
            Collections.sort(hitInfos, HitAnalysis.FRAME_COMPARATOR);
            for (HitAnalysis.HitInfo info : hitInfos) {
                result.addHitLine(info);
                LinkedList<Integer> frameObjects = (LinkedList<Integer>)excludedObjectsByFrame.get(info.getFrameIndex());
                if (frameObjects == null) {
                    frameObjects = new LinkedList<Integer>();
                    excludedObjectsByFrame.put(info.getFrameIndex(), frameObjects);
                }
                frameObjects.add(info.getObject().getIdentity());
            }
            boolean first = true;
            for (FrameKeyInfo frameKeyInfo : dumpFile.getInfos()) {
                if (first) {
                    first = false;
                    continue;
                }
                FrameInfo info = frameKeyInfo.getFrameInfo();
                List excludedObjects = (List)excludedObjectsByFrame.get(info.getIndex());
                for (MovingGameObject obj : this.getInterestingObjects(info)) {
                    if (excludedObjects != null && excludedObjects.contains(obj.getIdentity())) continue;
                    Point2D prevObjPos = obj.getCorrectedPredictedLocation(-1.0);
                    for (Bullet bullet : info.getBullets()) {
                        if (bullet.getLifetime() < 16) continue;
                        Point2D prevBulletPos = bullet.getCorrectedPredictedLocation(-1.0);
                        Line2D.Double line = new Line2D.Double(prevBulletPos.getX() - prevObjPos.getX(), prevBulletPos.getY() - prevObjPos.getY(), bullet.getCorrectedX() - obj.getCorrectedX(), bullet.getCorrectedY() - obj.getCorrectedY());
                        if (!SHOW_BOX.intersects(line.getBounds2D())) continue;
                        result.addMissLine(line, info.getIndex(), bullet, obj);
                    }
                }
            }
            return result;
        }

        protected abstract Collection<MovingGameObject> getInterestingObjects(FrameInfo var1);

        protected abstract Collection<HitAnalysis.HitInfo> getHitInfos(HitAnalysis var1);
    }

    private class OctagonalShapePainter
    extends ShapePainter {
        OctagonalShapePainter() {
            super(HitAnalysisDisplay.createOctagon());
        }
    }

    private class CircularShapePainter
    extends ShapePainter {
        CircularShapePainter() {
            super(new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
        }
    }

    private class RectangularShapePainter
    extends ShapePainter {
        RectangularShapePainter() {
            super(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0));
        }
    }

    private class NullShapePainter
    extends ShapePainter {
        NullShapePainter() {
            super(null);
        }
    }

    private abstract class ShapePainter {
        private final Shape shape;

        protected ShapePainter(Shape shape) {
            this.shape = shape;
        }

        public void drawShape(Graphics2D g) {
            if (this.shape != null) {
                Shape drawShape = AffineTransform.getScaleInstance(HitAnalysisDisplay.this.extractor.getSize() + HitAnalysisDisplay.this.deltaR, HitAnalysisDisplay.this.extractor.getSize() + HitAnalysisDisplay.this.deltaR).createTransformedShape(this.shape);
                if (HitAnalysisDisplay.this.deltaX != 0 || HitAnalysisDisplay.this.deltaY != 0) {
                    drawShape = AffineTransform.getTranslateInstance(HitAnalysisDisplay.this.deltaX, HitAnalysisDisplay.this.deltaY).createTransformedShape(drawShape);
                }
                g.setColor(Color.yellow);
                g.draw(drawShape);
                g.setColor(new Color(255, 255, 0, 64));
                g.fill(drawShape);
                g.setColor(new Color(255, 255, 255));
                g.drawLine(-4, 0, 4, 0);
                g.drawLine(0, -4, 0, 4);
            }
        }
    }

    private static interface DataExtractor {
        public HitAndMiss getHitAndMiss(DumpFile var1, HitAnalysis var2);

        public int getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HitAndMiss {
        private Collection<LineInfo> hitLines = new LinkedList<LineInfo>();
        private Collection<LineInfo> missLines = new LinkedList<LineInfo>();

        private HitAndMiss() {
        }

        public void addHitLine(HitAnalysis.HitInfo hitInfo) {
            this.hitLines.add(new LineInfo(new Line2D.Double(hitInfo.getPreDestructionDelta(), hitInfo.getDestructionDelta()), hitInfo.getFrameIndex(), hitInfo.getBullet(), hitInfo.getObject(), true));
        }

        public void addMissLine(Line2D line, int frameIndex, Bullet bullet, MovingGameObject object) {
            this.missLines.add(new LineInfo(line, frameIndex, bullet, object, false));
        }

        public Collection<LineInfo> getHitLines() {
            return Collections.unmodifiableCollection(this.hitLines);
        }

        public Collection<LineInfo> getMissLines() {
            return Collections.unmodifiableCollection(this.missLines);
        }
    }

    private static class LineInfo {
        private final Line2D line;
        private final int frameIndex;
        private final Bullet bullet;
        private final MovingGameObject object;
        private final boolean hit;

        public LineInfo(Line2D line, int frameIndex, Bullet bullet, MovingGameObject object, boolean hit) {
            this.line = line;
            this.frameIndex = frameIndex;
            this.bullet = bullet;
            this.object = object;
            this.hit = hit;
        }

        public Line2D getLine() {
            return this.line;
        }

        public int getFrameIndex() {
            return this.frameIndex;
        }

        public Bullet getBullet() {
            return this.bullet;
        }

        public MovingGameObject getObject() {
            return this.object;
        }

        public boolean isHit() {
            return this.hit;
        }

        public String toString() {
            return String.format("LineInfo(Line(%s, %s, %s, %s),\n         %6d, %4d, %4d, %s)", Double.toString(this.line.getX1()), Double.toString(this.line.getY1()), Double.toString(this.line.getX2()), Double.toString(this.line.getY2()), this.frameIndex, this.bullet.getIdentity(), this.object.getIdentity(), this.hit);
        }
    }
}

