/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.util.Tools;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulletLifetimeInformation
implements GameData {
    private static final int MARGIN_WIDTH = 32;
    private static final int CELL_WIDTH = 16;
    private static final int HOR_CELLS = 68;
    private static final int VER_CELLS = 52;
    private static final int HOR_CENTER = 34;
    private static final int VER_CENTER = 26;
    private static final Comparator<BulletFrameInfo> FRAME_COMPARATOR = new Comparator<BulletFrameInfo>(){

        @Override
        public int compare(BulletFrameInfo o1, BulletFrameInfo o2) {
            int result = o1.getFrame() - o2.getFrame();
            if (result != 0) {
                return result;
            }
            return o1.getDirection() - o2.getDirection();
        }
    };
    private static final BulletFramePositionInfo[][][] area = new BulletFramePositionInfo[68][52][];
    private static Map<Integer, BulletLifetimeInformation> cachedInfos;
    private BulletFrameInfo[][] hits;
    private final int overscan;

    public static BulletLifetimeInformation getLifetimeInformation(int size, int overscan) throws IOException {
        BulletLifetimeInformation info = cachedInfos.get(overscan);
        if (info == null) {
            info = new BulletLifetimeInformation(String.format("/data/hits-%d-%d.data", size, overscan));
            cachedInfos.put(overscan, info);
        }
        return info;
    }

    private BulletLifetimeInformation(String resource) throws IOException {
        OverscanAndHits oh = BulletLifetimeInformation.readHitsFromRessource(resource);
        this.overscan = oh.getOverscan();
        this.hits = oh.getHits();
        System.gc();
    }

    private static short[][] calculateHits(int size, int overscan) {
        size -= 2;
        double granularity = 1.0 / (double)overscan;
        short[][] hits = new short[1024 * overscan * 768 * overscan][];
        System.out.println("Starting initialization");
        long start = System.currentTimeMillis();
        Point2D.Double pos = new Point2D.Double();
        for (int s = 0; s < overscan; ++s) {
            System.out.println("s=" + s);
            for (int x = 0; x < 1024; ++x) {
                System.out.println("\tx=" + x);
                for (int t = 0; t < overscan; ++t) {
                    for (int y = 0; y < 768; ++y) {
                        int index = ((x * overscan + s) * 768 + y) * overscan + t;
                        double posX = (double)x + (double)s * granularity - 512.0;
                        double posY = (double)y + (double)t * granularity - 384.0;
                        pos.setLocation(posX, posY);
                        Collection<BulletFramePositionInfo> infos = BulletLifetimeInformation.getBulletFrameInfos(pos, size);
                        short[] entry = new short[infos.size()];
                        int e = 0;
                        for (BulletFramePositionInfo info : infos) {
                            entry[e++] = (short)(Tools.byteToUnsigned(info.getDirection()) << 8 | info.getFrame() & 0xFF);
                        }
                        if (y > 0 && Arrays.equals(entry, hits[index - overscan])) {
                            entry = hits[index - overscan];
                        } else if (t > 0 && Arrays.equals(entry, hits[index - 1])) {
                            entry = hits[index - 1];
                        } else if (x > 0 && Arrays.equals(entry, hits[index - 768 * overscan])) {
                            entry = hits[index - 768 * overscan];
                        } else if (s > 0 && Arrays.equals(entry, hits[index - 768])) {
                            entry = hits[index - 768];
                        }
                        hits[index] = entry;
                    }
                }
            }
        }
        System.out.println("Initialization lasted " + (System.currentTimeMillis() - start) + " ms");
        System.out.println("Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        return hits;
    }

    public BulletFrameInfo[] getHitBulletInfos(double x, double y) {
        x = Math.floor((double)this.overscan * x + 0.5) / (double)this.overscan;
        y = Math.floor((double)this.overscan * y + 0.5) / (double)this.overscan;
        int entryX = (int)Math.floor((GameObject.normalizeDeltaX(x) + 512.0) * (double)this.overscan);
        int entryY = (int)Math.floor((GameObject.normalizeDeltaY(y) + 384.0) * (double)this.overscan);
        try {
            return this.hits[entryX * 768 * this.overscan + entryY];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("x=" + x + ",y=" + y + ",entryX=" + entryX + ",entryY=" + entryY + ",len=" + this.hits.length);
            System.exit(2);
            return null;
        }
    }

    private static void saveHits(String filename, short[][] hits, int overscan) throws IOException {
        FileWriter fw = new FileWriter(filename);
        BufferedWriter bw = new BufferedWriter(fw, 0x100000);
        bw.write(String.format("*%d\n", overscan));
        HashMap<ShortArrayWrapper, Integer> mapping = new HashMap<ShortArrayWrapper, Integer>();
        int index = 0;
        boolean hitIndex = false;
        for (short[] hit : hits) {
            ShortArrayWrapper wrapper = new ShortArrayWrapper(hit);
            if (mapping.containsKey(wrapper)) continue;
            for (short h : hit) {
                bw.write(String.format("%d ", h));
            }
            bw.write("\n");
            mapping.put(wrapper, index++);
        }
        bw.write("[\n");
        int count = 0;
        ShortArrayWrapper lastWrapper = null;
        for (short[] hit : hits) {
            ShortArrayWrapper wrapper = new ShortArrayWrapper(hit);
            if (wrapper.equals(lastWrapper)) {
                ++count;
                continue;
            }
            if (lastWrapper != null) {
                if (count > 1) {
                    bw.write(Integer.toString(count));
                    bw.write("*");
                }
                bw.write(((Integer)mapping.get(lastWrapper)).toString());
                bw.write("\n");
            }
            lastWrapper = wrapper;
            count = 1;
        }
        if (lastWrapper != null) {
            if (count > 1) {
                bw.write(Integer.toString(count));
                bw.write("*");
            }
            bw.write(((Integer)mapping.get(lastWrapper)).toString());
            bw.write("\n");
        }
        bw.write("]\n");
        bw.close();
        fw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OverscanAndHits readHitsFromRessource(String resname) throws IOException {
        InputStream is = BulletLifetimeInformation.class.getResourceAsStream(resname);
        try {
            OverscanAndHits overscanAndHits = BulletLifetimeInformation.readHits(new InputStreamReader(is));
            return overscanAndHits;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OverscanAndHits readHits(String filename) throws IOException {
        FileReader fr = new FileReader(filename);
        try {
            OverscanAndHits overscanAndHits = BulletLifetimeInformation.readHits(fr);
            return overscanAndHits;
        }
        finally {
            fr.close();
        }
    }

    private static OverscanAndHits readHits(Reader reader) throws IOException {
        int i;
        BufferedReader br = new BufferedReader(reader, 0x100000);
        ArrayList<BulletFrameInfo[]> array = new ArrayList<BulletFrameInfo[]>(666666);
        String line = br.readLine().trim();
        if (!line.startsWith("*")) {
            throw new IOException(String.format("Missing overscan entry in line 1", new Object[0]));
        }
        int overscan = Integer.parseInt(line.substring(1));
        BulletFrameInfo[][] hits = new BulletFrameInfo[1024 * overscan * 768 * overscan][];
        line = br.readLine().trim();
        do {
            BulletFrameInfo[] newEntry;
            if (line.length() == 0) {
                newEntry = new BulletFrameInfo[]{};
            } else {
                String[] items = line.split(" ");
                newEntry = new BulletFrameInfo[items.length];
                for (i = items.length - 1; i >= 0; --i) {
                    short packed = Short.parseShort(items[i]);
                    newEntry[i] = new BulletFrameInfo((byte)((packed & 0xFF00) >> 8), packed & 0xFF);
                }
            }
            array.add(newEntry);
        } while (!"[".equals(line = br.readLine().trim()));
        int count = 0;
        BulletFrameInfo[] entry = null;
        for (i = 0; i < hits.length; ++i) {
            if (count == 0) {
                line = br.readLine().trim();
                String[] parts = line.split("\\*");
                if (parts.length == 2) {
                    count = Integer.parseInt(parts[0]);
                    entry = (BulletFrameInfo[])array.get(Integer.parseInt(parts[1]));
                } else {
                    count = 1;
                    entry = (BulletFrameInfo[])array.get(Integer.parseInt(line));
                }
            }
            hits[i] = entry;
            --count;
        }
        br.close();
        return new OverscanAndHits(overscan, hits);
    }

    private static void compressHits(short[][] hits) {
        HashMap<ShortArrayWrapper, Integer> map = new HashMap<ShortArrayWrapper, Integer>();
        int unique = 0;
        int doublett = 0;
        for (int i = 0; i < hits.length; ++i) {
            ShortArrayWrapper wrapper = new ShortArrayWrapper(hits[i]);
            Integer index = (Integer)map.get(wrapper);
            if (index == null) {
                map.put(wrapper, i);
                ++unique;
                continue;
            }
            hits[i] = hits[(Integer)map.get(wrapper)];
            ++doublett;
        }
        System.out.println("\tUnique:   " + unique);
        System.out.println("\tDoublett: " + doublett);
        System.out.println("\tTotal:    " + (unique + doublett));
    }

    private static Match mapToArea(double x, double y) {
        return BulletLifetimeInformation.mapToAreaUnnormalized(GameObject.normalizeDeltaX(x), GameObject.normalizeDeltaY(y));
    }

    private static Match mapToAreaUnnormalized(double x, double y) {
        int cellX = (int)Math.floor(x / 16.0);
        int cellY = (int)Math.floor(y / 16.0);
        return new Match(cellX + 34, cellY + 26, x - (double)(cellX * 16), y - (double)(cellY * 16));
    }

    public static Collection<BulletFramePositionInfo> getBulletFrameInfos(Point2D pos, int size) {
        LinkedList<BulletFramePositionInfo> result = new LinkedList<BulletFramePositionInfo>();
        Match match = BulletLifetimeInformation.mapToArea(pos.getX(), pos.getY());
        int minOffsetX = (int)Math.floor((match.getOffsetX() - (double)(size += 3)) / 16.0);
        int maxOffsetX = (int)Math.floor((match.getOffsetX() + (double)size) / 16.0);
        int minOffsetY = (int)Math.floor((match.getOffsetY() - (double)size) / 16.0);
        int maxOffsetY = (int)Math.floor((match.getOffsetY() + (double)size) / 16.0);
        double sizeSquared = Tools.square(size);
        for (int x = minOffsetX; x <= maxOffsetX; ++x) {
            for (int y = minOffsetY; y <= maxOffsetY; ++y) {
                for (BulletFramePositionInfo info : area[match.getCellX() + x][match.getCellY() + y]) {
                    if (!(Tools.square(info.getPosition().getX() - pos.getX()) + Tools.square(info.getPosition().getY() - pos.getY()) < sizeSquared)) continue;
                    result.add(info);
                }
            }
        }
        Collections.sort(result, FRAME_COMPARATOR);
        return result;
    }

    public void checkHits() {
        for (int i = 0; i < this.hits.length; ++i) {
            if (this.hits[i] != null) continue;
            System.out.println("hits[" + i + "]=null!");
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Need arguments!");
            System.exit(1);
        }
        if (args.length >= 3) {
            int size = Integer.parseInt(args[0]);
            int overscan = Integer.parseInt(args[1]);
            short[][] hits = BulletLifetimeInformation.calculateHits(size, overscan);
            System.out.println("Starting compression...");
            BulletLifetimeInformation.compressHits(hits);
            System.out.println("Finished compression.");
            System.out.println("Saving...");
            BulletLifetimeInformation.saveHits(args[2], hits, overscan);
            System.out.println("Finished saving.");
        } else {
            long start = System.currentTimeMillis();
            System.out.println("Starting read...");
            BulletLifetimeInformation.readHits(args[0]);
            System.out.println("Finished. Reading took " + (System.currentTimeMillis() - start) + " ms");
        }
        System.out.println("Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
    }

    static {
        for (int dir = 0; dir < 256; ++dir) {
            byte dirByte = (byte)dir;
            FrameInfo.Direction direction = FrameInfo.getShootingDirection(dir);
            double posX = direction.getDisplacement().x;
            double posY = direction.getDisplacement().y;
            for (int frame = 1; frame < 68; ++frame) {
                double nx = GameObject.normalizeDeltaX(posX);
                double ny = GameObject.normalizeDeltaY(posY);
                for (int deltaX : new int[]{-1024, 0, 1024}) {
                    for (int deltaY : new int[]{-768, 0, 768}) {
                        int cy;
                        Match m = BulletLifetimeInformation.mapToAreaUnnormalized(nx + (double)deltaX, ny + (double)deltaY);
                        if (!m.isValid()) continue;
                        BulletFramePositionInfo newInfo = new BulletFramePositionInfo(dirByte, frame, nx + (double)deltaX, ny + (double)deltaY);
                        int cx = m.getCellX();
                        if (area[cx][cy = m.getCellY()] == null) {
                            BulletLifetimeInformation.area[cx][cy] = new BulletFramePositionInfo[]{newInfo};
                            continue;
                        }
                        BulletFramePositionInfo[] newEntries = new BulletFramePositionInfo[area[cx][cy].length + 1];
                        System.arraycopy(area[cx][cy], 0, newEntries, 0, area[cx][cy].length);
                        newEntries[BulletLifetimeInformation.area[cx][cy].length] = newInfo;
                        BulletLifetimeInformation.area[cx][cy] = newEntries;
                    }
                }
                posX += direction.getBulletVelocity().getX();
                posY += direction.getBulletVelocity().getY();
            }
        }
        BulletFramePositionInfo[] empty = new BulletFramePositionInfo[]{};
        for (int x = 0; x < 68; ++x) {
            for (int y = 0; y < 52; ++y) {
                if (area[x][y] != null) continue;
                BulletLifetimeInformation.area[x][y] = empty;
            }
        }
        cachedInfos = new HashMap<Integer, BulletLifetimeInformation>();
    }

    private static class ShortArrayWrapper {
        private final short[] array;

        ShortArrayWrapper(short[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortArrayWrapper that = (ShortArrayWrapper)o;
            return Arrays.equals(this.array, that.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public short[] getArray() {
            return this.array;
        }
    }

    private static class OverscanAndHits {
        private final int overscan;
        private final BulletFrameInfo[][] hits;

        private OverscanAndHits(int overscan, BulletFrameInfo[][] hits) {
            this.overscan = overscan;
            this.hits = hits;
        }

        public int getOverscan() {
            return this.overscan;
        }

        public BulletFrameInfo[][] getHits() {
            return this.hits;
        }
    }

    private static class Match {
        private final int cellX;
        private final int cellY;
        private final double offsetX;
        private final double offsetY;

        private Match(int cellX, int cellY, double offsetX, double offsetY) {
            this.cellX = cellX;
            this.cellY = cellY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public int getCellX() {
            return this.cellX;
        }

        public int getCellY() {
            return this.cellY;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public boolean isValid() {
            return this.cellX >= 0 && this.cellX < 68 && this.cellY >= 0 && this.cellY < 52;
        }
    }

    public static class BulletFramePositionInfo
    extends BulletFrameInfo {
        private final Point2D position;

        BulletFramePositionInfo(byte direction, int frame, double x, double y) {
            super(direction, frame);
            this.position = new Point2D.Double(x, y);
        }

        public Point2D getPosition() {
            return this.position;
        }
    }

    public static class BulletFrameInfo {
        private final byte direction;
        private final int frame;

        BulletFrameInfo(byte direction, int frame) {
            this.direction = direction;
            this.frame = frame;
        }

        public byte getDirection() {
            return this.direction;
        }

        public int getFrame() {
            return this.frame;
        }
    }
}

