/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.Communication;
import de.caff.asteroid.analysis.FileFormat;
import de.caff.asteroid.server.DatagramListener;
import de.caff.asteroid.server.DatagramSender;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.util.concurrent.LinkedBlockingQueue;

public class DatagramDumper
implements DatagramListener,
Runnable,
FileFormat {
    private OutputStream out;
    private LinkedBlockingQueue<QueueElement> queue = new LinkedBlockingQueue();

    public DatagramDumper(String filename) throws IOException {
        this.out = new FileOutputStream(filename);
        this.out.write(DECAFF_INTRO);
    }

    private void insertDatagram(DatagramPacket packet) {
        if (this.out != null) {
            try {
                this.queue.put(new QueueElement(packet));
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void datagramReceived(DatagramPacket packet, DatagramSender sender) {
        this.insertDatagram(packet);
    }

    public void datagramSent(DatagramPacket packet) {
        this.insertDatagram(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        QueueElement element = this.queue.take();
                        element.writeTo(this.out);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Dumper dies due to i/o error!");
            try {
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
            }
            return;
        }
    }

    public static Thread registerDumper(Communication com, String filename) throws IOException {
        DatagramDumper dumper = new DatagramDumper(filename);
        com.addDatagramListener(dumper);
        Thread thread = new Thread((Runnable)dumper, "dumper");
        thread.start();
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                System.err.println("Dumper thread passed out.");
                e.printStackTrace(System.err);
                System.exit(1);
            }
        });
        return thread;
    }

    private static class QueueElement {
        private long timestamp = System.currentTimeMillis();
        private byte[] data;

        private QueueElement(DatagramPacket packet) {
            this.data = new byte[packet.getLength()];
            System.arraycopy(packet.getData(), 0, this.data, 0, packet.getLength());
        }

        public void writeTo(OutputStream os) throws IOException {
            os.write(this.data.length == 1026 ? 73 : 79);
            long ts = this.timestamp;
            for (int b = 8; b > 0; --b) {
                os.write((int)ts & 0xFF);
                ts >>= 8;
            }
            os.write(this.data);
        }
    }
}

