/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Drawable;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text
extends GameObject
implements Drawable {
    public static final Color TEXT_COLOR = Color.gray;
    private static final Map<Character, Glyph> GLYPH_MAP = new HashMap<Character, Glyph>();
    public static final Glyph SPACE_GLYPH;
    public static final Font FONT;
    private final String text;
    private final int scale;

    public Text(String text, int x, int y, int scale) {
        super(x, y);
        this.text = text;
        this.scale = (int)Math.pow(2.0, scale);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.format("Text(%s)@(%d,%d)", this.text, this.getX(), this.getY());
    }

    public boolean hasLocation(int px, int py) {
        return px == this.x && py == this.y;
    }

    public boolean hasLocation(Point p) {
        return this.hasLocation(p.x, p.y);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        AffineTransform trafo = AffineTransform.getScaleInstance(this.scale, this.scale);
        Point offset = new Point(this.getX(), this.getY());
        for (char ch : this.text.toCharArray()) {
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            Rectangle glyphBounds = glyph.getBounds(trafo);
            glyphBounds.translate(offset.x, offset.y);
            bounds = bounds == null ? glyphBounds : bounds.union(glyphBounds);
            Point glyphOffset = glyph.getOffset();
            offset.x += this.scale * glyphOffset.x;
            offset.y += this.scale * glyphOffset.y;
        }
        if (bounds == null) {
            bounds = new Rectangle(this.getX(), this.getY(), 1, 1);
        }
        return bounds;
    }

    public int getScale() {
        return this.scale;
    }

    public Font getFont() {
        return FONT.deriveFont((float)(FONT.getSize() * this.scale));
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<String>("Text", this.getText()));
        props.add(new Property<Integer>("Scale", this.getScale()));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Text";
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.x, this.y);
        g2.setColor(TEXT_COLOR);
        Text.drawText(g2, this.text, this.scale);
    }

    public static void drawText(Graphics2D g, String text, double scale) {
        for (char ch : text.toCharArray()) {
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            glyph.drawAndTranslate(g, scale);
        }
    }

    public static Glyph getGlyph(char ch) {
        return GLYPH_MAP.get(Character.valueOf(ch));
    }

    public static Glyph getGlyph(char ch, Glyph fallback) {
        Glyph glyph = Text.getGlyph(ch);
        return glyph == null ? fallback : glyph;
    }

    public static Rectangle getTextBounds(String text, double scale) {
        Rectangle bounds = null;
        AffineTransform trafo = AffineTransform.getScaleInstance(scale, scale);
        Point offset = new Point();
        for (char ch : text.toCharArray()) {
            Glyph glyph = GLYPH_MAP.get(Character.valueOf(ch));
            if (glyph == null) {
                glyph = SPACE_GLYPH;
            }
            Rectangle glyphBounds = glyph.getBounds(trafo);
            glyphBounds.translate(offset.x, offset.y);
            bounds = bounds == null ? glyphBounds : bounds.union(glyphBounds);
            Point glyphOffset = glyph.getOffset();
            offset.x = (int)((double)offset.x + scale * (double)glyphOffset.x);
            offset.y = (int)((double)offset.y + scale * (double)glyphOffset.y);
        }
        return bounds;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Render text in asteroids font.");
            System.out.println("  Understanding the following arguments:");
            System.out.println("  [-a] [-b <border>] [-s <scale>] [-r <radius>] [-l <width>] <filename> text ...");
            System.out.println("\t-a             use antialias [Default: off]");
            System.out.println("\t-b <border>    border around text [Default: 20]");
            System.out.println("\t-s <scale>     scaling for text [Default: 1 (12 pixel)]");
            System.out.println("\t-r <radius>    corner radius [Default: 0]");
            System.out.println("\t-l <width>     line width");
            System.out.println("\t<filename>     name of output file (in PNG format)");
            System.out.println("\ttext           text to render");
            System.exit(0);
        }
        boolean antialias = false;
        String filename = null;
        String text = null;
        double scale = 1.0;
        int border = 20;
        int roundness = 0;
        int lineWidth = 1;
        for (int a = 0; a < args.length; ++a) {
            if ("-a".equals(args[a])) {
                antialias = true;
                continue;
            }
            if ("-b".equals(args[a])) {
                border = Integer.parseInt(args[++a]);
                continue;
            }
            if ("-s".equals(args[a])) {
                scale = Double.parseDouble(args[++a]);
                continue;
            }
            if ("-r".equals(args[a])) {
                roundness = Integer.parseInt(args[++a]);
                continue;
            }
            if ("-l".equals(args[a])) {
                lineWidth = Integer.parseInt(args[++a]);
                continue;
            }
            if (filename == null) {
                filename = args[a];
                continue;
            }
            text = text == null ? args[a] : text + " " + args[a];
        }
        text = FrameInfo.canonize(text);
        Rectangle bounds = Text.getTextBounds(text, scale);
        BufferedImage image = new BufferedImage(2 * border + bounds.width, 2 * border + bounds.height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.black);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        System.out.println("bounds=" + bounds);
        System.out.println("image: " + image.getWidth() + "x" + image.getHeight());
        if (roundness > 0) {
            g.fillRoundRect(0, 0, image.getWidth(), image.getHeight(), roundness, roundness);
        } else {
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        Point offset = new Point(bounds.x + (image.getWidth() - bounds.width) / 2, bounds.y + (image.getHeight() - bounds.height) / 2 + bounds.height);
        g.translate(offset.x, offset.y);
        g.scale(1.0, -1.0);
        g.setStroke(new BasicStroke(lineWidth, 1, 1));
        g.setColor(Color.gray);
        Text.drawText(g, text, scale);
        ImageIO.write((RenderedImage)image, "PNG", new File(filename));
        System.out.println("Written '" + text + "' to " + filename);
    }

    @Override
    public void visitedBy(GameObjectVisitor visitor) {
        visitor.handle(this);
    }

    static {
        GLYPH_MAP.put(Character.valueOf('A'), new Glyph(new byte[]{0, -8, 7, -4, -12, 7, -8, -8, 7, -8, 0, 7, 0, -4, 0, -8, -4, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('B'), new Glyph(new byte[]{0, -12, 7, -6, -12, 7, -8, -10, 7, -8, -8, 7, -6, -6, 7, 0, -6, 7, -6, -6, 0, -8, -4, 7, -8, -2, 7, -6, 0, 7, 0, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('C'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, 0, 0, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('D'), new Glyph(new byte[]{0, -12, 7, -4, -12, 7, -8, -8, 7, -8, -4, 7, -4, 0, 7, 0, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('E'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -6, -6, 0, 0, -6, 7, 0, 0, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('F'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -6, -6, 0, 0, -6, 7, 0, 0, 0, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('G'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -8, -8, 7, -4, -4, 0, -8, -4, 7, -8, 0, 7, 0, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('H'), new Glyph(new byte[]{0, -12, 7, 0, -6, 0, -8, -6, 7, -8, -12, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('I'), new Glyph(new byte[]{-8, 0, 7, -4, 0, 0, -4, -12, 7, -8, -12, 0, 0, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('J'), new Glyph(new byte[]{0, -4, 0, -4, 0, 7, -8, 0, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('K'), new Glyph(new byte[]{0, -12, 7, -6, -12, 0, 0, -6, 7, -6, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('L'), new Glyph(new byte[]{0, -12, 0, 0, 0, 7, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('M'), new Glyph(new byte[]{0, -12, 7, -4, -8, 7, -8, -12, 7, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('N'), new Glyph(new byte[]{0, -12, 7, -8, 0, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('0'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -8, 0, 7, 0, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('P'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -8, -6, 7, 0, -6, 7, -6, 0, 0, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('Q'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -8, -4, 7, -4, 0, 7, 0, 0, 7, -4, -4, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('R'), new Glyph(new byte[]{0, -12, 7, -8, -12, 7, -8, -6, 7, 0, -6, 7, -2, -6, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('S'), new Glyph(new byte[]{-8, 0, 7, -8, -6, 7, 0, -6, 7, 0, -12, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('T'), new Glyph(new byte[]{-4, 0, 0, -4, -12, 7, 0, -12, 0, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('U'), new Glyph(new byte[]{0, -12, 0, 0, 0, 7, -8, 0, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('V'), new Glyph(new byte[]{0, -12, 0, -4, 0, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('W'), new Glyph(new byte[]{0, -12, 0, 0, 0, 7, -4, -4, 7, -8, 0, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('X'), new Glyph(new byte[]{-8, -12, 7, 0, -12, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('Y'), new Glyph(new byte[]{-4, 0, 0, -4, -8, 7, 0, -12, 7, -8, -12, 0, -4, -8, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('Z'), new Glyph(new byte[]{0, -12, 0, -8, -12, 7, 0, 0, 7, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf(' '), new Glyph(new byte[]{-12, 0, 0}, new Rectangle(0, 0, 8, 12)));
        GLYPH_MAP.put(Character.valueOf('1'), new Glyph(new byte[]{-4, 0, 0, -4, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('2'), new Glyph(new byte[]{0, -12, 0, -8, -12, 7, -8, -6, 7, 0, -6, 7, 0, 0, 7, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('3'), new Glyph(new byte[]{-8, 0, 7, -8, -12, 7, 0, -12, 7, 0, -6, 0, -8, -6, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('4'), new Glyph(new byte[]{0, -12, 0, 0, -6, 7, -8, -6, 7, -8, -12, 0, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('5'), new Glyph(new byte[]{-8, 0, 7, -8, -6, 7, 0, -6, 7, 0, -12, 7, -8, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('6'), new Glyph(new byte[]{0, -6, 0, -8, -6, 7, -8, 0, 7, 0, 0, 7, 0, -12, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('7'), new Glyph(new byte[]{0, -12, 0, -8, -12, 7, -8, 0, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('8'), new Glyph(new byte[]{-8, 0, 7, -8, -12, 7, 0, -12, 7, 0, 0, 7, 0, -6, 0, -8, -6, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('9'), new Glyph(new byte[]{-8, 0, 0, -8, -12, 7, 0, -12, 7, 0, -6, 7, -8, -6, 7, -12, 0, 0}));
        GLYPH_MAP.put(Character.valueOf('\''), new Glyph(new byte[]{-4, -8, 0, -4, -12, 7, -12, 0, 0}));
        SPACE_GLYPH = GLYPH_MAP.get(Character.valueOf(' '));
        FONT = new Font("Monospaced", 0, 14);
    }
}

