#include "Ufo.h"
#include "iostream"
using namespace std;

Ufo::Ufo()
{
	maxShots = 1;
	nShots = 0;
}

void Ufo::calcRelationsToShip(GameObject ship)
{
	calcSpeed();
	if(maxShots <= nShots)
	{
		shotAt = true;
		if(++shotResetCounter >= SHOTRESETFRAMES)
		{
			nShots = 0;
		}
	}
	else
	{
		shotAt = false;
		shotResetCounter = 0;
	}
	if (isPresent && speed > 0)
    {
		switch(size)
		{
		case 14 :
			r = 8;
			break;
		case 15 :
			r = 12;
			break;
		}
		virtualPosition = position + dir;

		Vector2D AS = position - ship.position;
		if(AS.x > -1024 && AS.y > -1024)
		{
			while (AS.x < -512)
			{	
				virtualPosition.x += 1024;
				AS = virtualPosition - ship.position;
			}
			while (AS.x > 511)
			{
				virtualPosition.x -= 1024;
				AS = virtualPosition - ship.position;
			}
			while (AS.y < -512)
			{
				virtualPosition.y += 1024;
				AS = virtualPosition - ship.position;
			}
			while (AS.y > 511)
			{
				virtualPosition.y -= 1024;
				AS = virtualPosition - ship.position;
			}
		}
		distanceToShip = AS.Length();
		//Calculate aimingPosition
		AS.Normalize();
		dir.Normalize();
		
		Vector2D ST;
        bool   calccomplete = false;

		double beta = acos(AS.Dot(dir));

		double alpha = asin((sin(beta) * (speed/7.8)));

		double gamma = PI-alpha-beta;

		double check;
		double check2;
		if(gamma != 0)
		{
			double roidtotarget = (sin(alpha)/sin(gamma)) * distanceToShip;
			aimLocation = virtualPosition + dir * roidtotarget;
			ST = aimLocation - ship.position;
			
			double d=pow(10.0,5);
			
			check = ST.Length()/7.8;
			check = floor(check*d+0.5)/d;

			check2 = roidtotarget/speed;
			check2 = floor(check2*d+0.5)/d;

			if(check == check2)
				calccomplete = true;
		}
		else
		{
			aimLocation = position;
			calccomplete = true;
		}

		if(!calccomplete && beta != 0)
		{
			beta = PI - beta;
					
			double alpha = asin((sin(beta) * (speed/7.8)));

			double gamma = PI-alpha-beta;

			if(gamma != 0)
			{
				double roidtotarget = (sin(alpha)/sin(gamma)) * distanceToShip;
				aimLocation = virtualPosition + dir * roidtotarget;
				ST = aimLocation - ship.position;
				double d=pow(10.0,5);
			
				check = ST.Length()/7.8;
				check = floor(check*d+0.5)/d;

				check2 = roidtotarget/speed;
				check2 = floor(check2*d+0.5)/d;
				if(check == check2)
					calccomplete = true;
			}
			else
			{
				aimLocation = position;
				calccomplete = true;
			}
		}
		if(calccomplete = false)
			cout << "something is wrong with the calculation of the ufo \n";


		ST = aimLocation - ship.position;
		Vector2D shipDir = ship.shotVector->getcurrentvec();
        shipDir.Normalize();
        angleToShipDEG = acos(shipDir.Dot(ST)) * RAD2DEG;
        double angleRot = ST.AngleDEG() - ship.dir.AngleDEG();
        if (angleRot<0) angleRot+=360;
        rotationDir =  (angleRot < 180) ? 1 : -1;
    } 
    else 
    {
		willHit = false;
        distSH = 0;
        distTH = 0;
    }
}
