#ifndef UFO_H_
#define UFO_H_

#include "FlyingObject.h"
#include "UfoSize.h"

class Ufo:public FlyingObject
{
private:
	UfoSize size;
	int hits;
public:
	Ufo(int objectID,
		wxPoint absolutePosition,
	    Angle   absoluteAngle,
	    wxPoint relativePosition,
	    Angle   relativeAngle,
	    int velocity,
	    wxPoint flightVector,
	    wxPoint relativeFlightVector,
	    int distance,
	    int framesToCollision,
	    int lifeTime,
	    UfoSize size);
	
	Ufo():FlyingObject(),size(UfoSize::small)
	{
	}
	unsigned int getSize() const;
	
	UfoSize getUfoSize() const
	{
		return size;
	}
	
	int getHits()
	{
		return hits;
	}
	
	void addHit()
	{
		hits++;
	}
	
};

#endif /*UFO_H_*/
