#include "Program.h"
#include <iostream>
#include <wx/cmdline.h>
#include "Tools.h"
#include "rdtsc.h"
#include "YAPlayer.h"
#include "defines.h"

IMPLEMENT_APP_CONSOLE(Program)

int Program::OnRun()
{
	wxCmdLineParser parser(argc, argv);
	parser.AddParam(_("IP"));
	if(parser.Parse(true))
		return 1;
	player = new YAPlayer();

	ip = parser.GetParam();
	
	initApplication();
	
	#ifndef _BOT_SINGLETHREADED_
	player->playGame(repository);
	#endif
	
	#ifdef _BOT_SINGLETHREADED_
	runSingleThreaded();
	#endif
	
	terminateApplication();
	return 0;
}

bool Program::OnInit()
{
	return true;
}

void Program::initApplication()
{
	repository = new Repository();
	try
	{
		ioLayer = new IOLayer(ip.ToAscii(),repository);
	}
	catch(SocketException e)
	{
		cerr << "Socket Exception: " << e.what() << endl;
	}
	
	trackingLayer = new TrackingLayer(repository);
	
	#ifndef _BOT_SINGLETHREADED_
	ioLayerSend = new IOLayerSendThread(ioLayer);
	ioLayerReceive = new IOLayerReceiveThread(ioLayer);

	ioLayerSend->Create();
	ioLayerSend->Run();
	
	ioLayerReceive->Create();
	ioLayerReceive->Run();
	
	trackingLayer->Create();
	trackingLayer->Run(); 
	#endif
}

void Program::terminateApplication()
{
	#ifndef _SINGLETHREADED_
	if(trackingLayer->IsAlive())
		trackingLayer->Delete();
	
	if(ioLayerReceive->IsAlive())
		ioLayerReceive->Delete();
	
	if(ioLayerSend->IsAlive())
		ioLayerSend->Delete();
	#endif

	if(m_pLogFile)
		fclose(m_pLogFile);
	
	delete player;
	delete ioLayer;
	delete repository;
}

#ifdef _BOT_SINGLETHREADED_
//multithreaded sollte das gleiche durch die versch. Threads und Player::playGame() ausgefuehrt werden
void Program::runSingleThreaded()
{
	ioLayer->sendData();
	while(true)
	{
		bool test1 = ioLayer->receiveData();
		if(test1)
		{
			((TrackingLayer*)trackingLayer)->trackData();
			Universe* universe = repository->popUniverse();
			if(universe)
			{
				char test2 = player->decideMove(universe);
				repository->setKeys(test2);
			}
			ioLayer->sendData();
		}
	}
}
#endif

