#include "config.h"


Config::Config(QWidget *parent):
	QWidget(parent)
{
	QVBoxLayout *mainLayout = new QVBoxLayout;
	setLayout(mainLayout);

	QHBoxLayout *speedSamplesLayout = new QHBoxLayout;
	mainLayout->addLayout(speedSamplesLayout);
	QLabel *lSpeedSamples = new QLabel("Velocity Samples:", this);
	speedSamplesLayout->addWidget(lSpeedSamples);
	spSpeedSamples = new QSpinBox(this);
	speedSamplesLayout->addWidget(spSpeedSamples);
	spSpeedSamples->setMaximum(50);
	spSpeedSamples->setMinimum(2);
	spSpeedSamples->setValue(Options::SpeedSamples);
	connect(spSpeedSamples, SIGNAL(valueChanged(int)), this, SLOT(speedSamplesChanged(int)));


	

	QHBoxLayout *angleLayout = new QHBoxLayout;
	mainLayout->addLayout(angleLayout);
	QLabel *lAngle = new QLabel("Angle", this);
	angleLayout->addWidget(lAngle);
	spAngle = new QSpinBox(this);
	angleLayout->addWidget(spAngle);
	spAngle->setMaximum(359);
	spAngle->setMinimum(0);
	spAngle->setValue(Options::Angle);
	QPushButton *bAngle = new QPushButton("Apply", this);
	angleLayout->addWidget(bAngle);
	connect(bAngle, SIGNAL(clicked()), this, SLOT(applyAngle()));


	QTabWidget *taWidget = new QTabWidget(this);
	mainLayout->addWidget(taWidget);
	

	QTableWidget *tbWidget = new QTableWidget(3,2,taWidget);
	taWidget->addTab(tbWidget, "Radius Filter");
	mainLayout->addStretch();
	QStringList vHeaderList;
	vHeaderList << "Small" << "Medium" << "Big";
	tbWidget->setVerticalHeaderLabels(vHeaderList);
	QStringList hHeaderList;
	hHeaderList << "Minimum" << "Maximum";
	tbWidget->setHorizontalHeaderLabels(hHeaderList);
	QSpinBox *spSMin = new QSpinBox(tbWidget);
	spSMin->setMinimum(10);
	spSMin->setMaximum(100);
	spSMin->setValue(Options::R.SmallMin);
	connect(spSMin, SIGNAL(valueChanged(int)), this, SLOT(rMinSmallChanged(int)));
	tbWidget->setCellWidget(0, 0, spSMin);
	QSpinBox *spSMax = new QSpinBox(tbWidget);
	spSMax->setMinimum(10);
	spSMax->setMaximum(100);
	spSMax->setValue(Options::R.SmallMax);
	connect(spSMax, SIGNAL(valueChanged(int)), this, SLOT(rMaxSmallChanged(int)));
	tbWidget->setCellWidget(0, 1, spSMax);
	QSpinBox *spMMin = new QSpinBox(tbWidget);
	spMMin->setMinimum(10);
	spMMin->setMaximum(100);
	spMMin->setValue(Options::R.MediumMin);
	connect(spMMin, SIGNAL(valueChanged(int)), this, SLOT(rMinMediumChanged(int)));
	tbWidget->setCellWidget(1, 0, spMMin);
	QSpinBox *spMMax = new QSpinBox(tbWidget);
	spMMax->setMinimum(10);
	spMMax->setMaximum(100);
	spMMax->setValue(Options::R.MediumMax);
	connect(spMMax, SIGNAL(valueChanged(int)), this, SLOT(rMaxMediumChanged(int)));
	tbWidget->setCellWidget(1, 1, spMMax);
	QSpinBox *spBMin = new QSpinBox(tbWidget);
	spBMin->setMinimum(10);
	spBMin->setMaximum(100);
	spBMin->setValue(Options::R.BigMin);
	connect(spBMin, SIGNAL(valueChanged(int)), this, SLOT(rMinBigChanged(int)));
	tbWidget->setCellWidget(2, 0, spBMin);
	QSpinBox *spBMax = new QSpinBox(tbWidget);
	spBMax->setMinimum(10);
	spBMax->setMaximum(100);
	spBMax->setValue(Options::R.BigMax);
	connect(spBMax, SIGNAL(valueChanged(int)), this, SLOT(rMaxBigChanged(int)));
	tbWidget->setCellWidget(2, 1, spBMax);

	QWidget *helpWidget = new QWidget(taWidget);
	taWidget->addTab(helpWidget, "Help Lines");
	QVBoxLayout *mainHelpLayout = new QVBoxLayout;
	helpWidget->setLayout(mainHelpLayout);
	QCheckBox *cCross = new QCheckBox("Cross", helpWidget);
	mainHelpLayout->addWidget(cCross);
	cCross->setChecked(Options::ShowCross);
	connect(cCross, SIGNAL(stateChanged(int)), this, SLOT(cCheckChanged(int)));

//mre 
	QTabWidget *defWidget = new QTabWidget(this);
	mainLayout->addWidget(defWidget);
	

	QTableWidget *tdefWidget = new QTableWidget(3,2,defWidget);
	defWidget->addTab(tdefWidget, "ShotSpeed Options");
	mainLayout->addStretch();
	QStringList vdefHeaderList;
	vdefHeaderList << "v / 10" << "vrad / 100" << "OffSet / 10";
	tdefWidget->setVerticalHeaderLabels(vdefHeaderList);
	QStringList hdefHeaderList;
	hdefHeaderList << "anfliegend" << "entfernend";
	tdefWidget->setHorizontalHeaderLabels(hdefHeaderList);

	QSpinBox *avValSet = new QSpinBox(tdefWidget);
	avValSet->setMinimum(0);
	avValSet->setMaximum(10000);
	avValSet->setValue(Options::Def.anVspeed * 10);
	connect(avValSet, SIGNAL(valueChanged(int)), this, SLOT(avVal(int)));
	tdefWidget->setCellWidget(0, 0, avValSet);

	QSpinBox *evValSet = new QSpinBox(tdefWidget);
	evValSet->setMinimum(0);
	evValSet->setMaximum(10000);
	evValSet->setValue(Options::Def.enVspeed * 10);
	connect(evValSet, SIGNAL(valueChanged(int)), this, SLOT(evVal(int)));
	tdefWidget->setCellWidget(0, 1, evValSet);

	QSpinBox *arValSet = new QSpinBox(tdefWidget);
	arValSet->setMinimum(0);
	arValSet->setMaximum(10000);
	arValSet->setValue(Options::Def.anRadSpeed * 100);
	connect(arValSet, SIGNAL(valueChanged(int)), this, SLOT(arVal(int)));
	tdefWidget->setCellWidget(1, 0, arValSet);

	QSpinBox *erValSet = new QSpinBox(tdefWidget);
	erValSet->setMinimum(0);
	erValSet->setMaximum(10000);
	erValSet->setValue(Options::Def.enRadSpeed * 100);
	connect(erValSet, SIGNAL(valueChanged(int)), this, SLOT(erVal(int)));
	tdefWidget->setCellWidget(1, 1, erValSet);

	QSpinBox *anOffSet = new QSpinBox(tdefWidget);
	anOffSet->setMinimum(-1000);
	anOffSet->setMaximum(1000);
	anOffSet->setValue(Options::Def.offsetAn * 10);
	connect(anOffSet, SIGNAL(valueChanged(int)), this, SLOT(anOff(int)));
	tdefWidget->setCellWidget(2, 0, anOffSet);

	QSpinBox *enOffSet = new QSpinBox(tdefWidget);
	enOffSet->setMinimum(-1000);
	enOffSet->setMaximum(1000);
	enOffSet->setValue(Options::Def.offsetEn * 10);
	connect(enOffSet, SIGNAL(valueChanged(int)), this, SLOT(enOff(int)));
	tdefWidget->setCellWidget(2, 1, enOffSet);
}

Config::~Config()
{
}

void Config::speedSamplesChanged(int value)
{
	Options::SpeedSamples = value;
}

void Config::applyAngle()
{
	Options::Angle = spAngle->value();
}

void Config::rMinSmallChanged(int value)
{
	Options::R.SmallMin = (double)value;
}

void Config::rMaxSmallChanged(int value)
{
	Options::R.SmallMax = (double)value;
}

void Config::rMinMediumChanged(int value)
{
	Options::R.MediumMin = (double)value;
}

void Config::rMaxMediumChanged(int value)
{
	Options::R.MediumMax = (double)value;
}

void Config::rMinBigChanged(int value)
{
	Options::R.BigMin = (double)value;
}

void Config::rMaxBigChanged(int value)
{
	Options::R.BigMax = (double)value;
}

void Config::cCheckChanged(int state)
{
	if(state)
	{
		Options::ShowCross = true;
	}
	else
	{
		Options::ShowCross = false;
	}

}
// mre

void Config::avVal(int value)
{
	Options::Def.anVspeed = (double)value / 10;
}

void Config::evVal(int value)
{
	Options::Def.enVspeed = (double)value / 10;
}

void Config::arVal(int value)
{
	Options::Def.anRadSpeed = (double)value / 100;
}

void Config::erVal(int value)
{
	Options::Def.enRadSpeed = (double)value / 100;
}
void Config::anOff(int value)
{
	Options::Def.offsetAn = (double)value / 10;
}
void Config::enOff(int value)
{
	Options::Def.offsetEn = (double)value / 10;
}