package doertbrexel.spaceobjects;

public class Asteroid extends SpaceObject
{
	private static final int	KORR_SMALL_ASTEROID		= 8 * 8;
	private static final int	PONTS_SMALL_ASTEROID	= 20;
	private static final int	KORR_MIDDLE_ASTEROID	= 20 * 20;
	private static final int	PONTS_MIDDLE_ASTEROID	= 50;
	private static final int	KORR_GREAT_ASTEROID		= 40 * 40;
	private static final int	PONTS_GREAT_ASTEROID	= 100;

	private int					mScalingFactor;

	public Asteroid(final int pX, final int pY, final int pType, final int pScalingFactor)
	{
		super(pX, pY);
		mType = pType;
		mScalingFactor = pScalingFactor;
		switch (mScalingFactor)
		{ // Abstand um den ungefhren Radius des Asteroiden
			// korrigieren
			case 0 : // groer Asteroid
				mKorr = KORR_GREAT_ASTEROID;
				mRating = PONTS_GREAT_ASTEROID;
				break;
			case 15 : // mittlerer Asteroid
				mKorr = KORR_MIDDLE_ASTEROID;
				mRating = PONTS_MIDDLE_ASTEROID;
				break;
			case 14 : // kleiner Asteroid
				mKorr = KORR_SMALL_ASTEROID;
				mRating = PONTS_SMALL_ASTEROID;
				break;
		}
	}

	public int getScalingFactor()
	{
		return mScalingFactor;
	}

}
