package doertbrexel.operations;

import java.io.ByteArrayInputStream;

public class OperationFactory
{
	ByteArrayInputStream	mVectorRamInputStream	= null;
	int						mAddressPointer			= 0;
	public OperationFactory(ByteArrayInputStream pVectorRamInputStream)
	{
		mVectorRamInputStream = pVectorRamInputStream;
	}

	public Operation next()
	{
		int pAddressPointer = mAddressPointer;
		int rightByte = mVectorRamInputStream.read() & 0x000000FF;
		int leftByte = mVectorRamInputStream.read() & 0x000000FF;
		mAddressPointer++;
		int opcode = (leftByte & 0x000000F0) >>> 4;
		int firstWord = ((leftByte & 0x0000000F) << 8) | rightByte;
		if (opcode >= Operation.OPCODE_VCTR_MIN && opcode <= Operation.OPCODE_VCTR_MAX)
		{
			return new VctrOperation(pAddressPointer, opcode, firstWord,
					getNextWord(mVectorRamInputStream));
		} else if (opcode == Operation.OPCODE_LABS)
			return new LabsOperation(pAddressPointer, opcode, firstWord,
					getNextWord(mVectorRamInputStream));
		else if (opcode == Operation.OPCODE_HALT)
			return new HaltOperation(pAddressPointer, opcode, firstWord);
		else if (opcode == Operation.OPCODE_JSRL)
			return new JsrlOperation(pAddressPointer, opcode, firstWord);
		else if (opcode == Operation.OPCODE_RTSL)
			return new RtslOperation(pAddressPointer, opcode, firstWord);
		else if (opcode == Operation.OPCODE_JMPL)
			return new JmplOperation(pAddressPointer, opcode, firstWord);
		else if (opcode == Operation.OPCODE_SVEC)
			return new SvecOperation(pAddressPointer, opcode, firstWord);
		else
			return null;
	}

	private int getNextWord(ByteArrayInputStream pVectorRam)
	{
		int rightByte = pVectorRam.read() & 0x000000FF;
		int leftByte = pVectorRam.read() & 0x000000FF;
		mAddressPointer++;
		int word = (leftByte << 8) | rightByte;
		return word;
	}
}
