package doertbrexel.operations;

import doertbrexel.GameStatus;
import doertbrexel.ProcessorContext;

/**
 * @author G.Doert-Brexel
 * 
 * Setzt den Strahl auf die absolute Position (X,Y) und setzt den
 * globalen Skalierungsfaktor.
 * Y = Bits 0 ... 9 aus erstem Wort
 * X = Bits 0 ... 9 aus zweitem Wort
 * 
 * Globaler Skalierungsfaktor = Bits 12 ... 15 aus erstem Wort
 *
 */
public class LabsOperation extends TwoWordOperation
{
	private int	mAbsX					= -1;
	private int	mAbsY					= -1;
	private int	mGlobalScalingFactor	= -1;

	protected LabsOperation(int pAddressPointer, int pOpcode, int pFirstWord,
			int pSecondWord)
	{
		super(pAddressPointer, pOpcode, pFirstWord, pSecondWord);
		mAbsY = pFirstWord;
		mAbsX = pSecondWord & 0x000003FF;
		mGlobalScalingFactor = (pSecondWord & 0x0000F000) >>> 12;
	}

	public String toString()
	{
		return getAddress() + " LABS - " + super.toString() + "-> AbsX=" + mAbsX
				+ " AbsY=" + mAbsY + " GlobalScalingFactor=" + mGlobalScalingFactor;
	}

	@Override
	public boolean execute(ProcessorContext processorContext, GameStatus pGameStatus)
	{
		processorContext.absX = mAbsX;
		processorContext.absY = mAbsY;
		processorContext.globalScalingFactor = mGlobalScalingFactor;
		return false;
	}
}
