/* lpq.c $Id: lpq.c,v 1.3 2000/08/31 22:05:14 angus Exp $
 *
 * Copyright (C) Angus J. C. Duggan, 1996-2000
 *
 * LPQ client for NT; uses registry and PRINTER environment variable for
 * printer. PRINTHOST registry key and environment variable used for LPD host.
 * LPR and LPRM also provided.
 */

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "common.h"

char *program ;

static void usage(void)
{
  error("Copyright (C) Angus J. C. Duggan, 1996-2000. See file LICENSE for details.\nUsage:\n  %s [-Pprinter] [-Hhost] [user|job...]\n", program) ;
}

int ShowQueue(char *printer, char *hostname, SOCKET printsock, va_list args)
{
  int lpdcmd = va_arg(args, int) ;
  char *list = va_arg(args, char *) ;
  unsigned char buffer[BUFSIZ] ;
  int len, column = 0 ;

  if ( !Command("%c%s %s\n", lpdcmd, printer, (list ? list : "")) )
    return 1 ;

  if ( !Reply(hostname, printsock, stdout) )
    return 1 ;

  return 0 ;
}

int main(int argc, char *argv[])
{
  LPDCommand lpdcmd = LPD_SHORTQ ;
  char *printer = getenv(PRINTER) ;
  char *host = DefaultHost(printer) ;
  char *list = NULL ;

  for (program = *argv++ ; --argc ; argv++) {
    if (argv[0][0] == '-') {
      switch (argv[0][1]) {
      case 'l':	/* Long */
	lpdcmd = LPD_LONGQ ;
	break;
      case 'P':	/* printer */
	printer = &(argv[0][2]) ;
        host = DefaultHost(printer) ;
	break;
      default:
	usage();
      }
    } else {
      int len = list ? strlen(list) + 1 : 0 ;

      list = xalloc(list, len + strlen(*argv) + 1) ;
      if ( len != 0 )	/* concat string with space separators */
	list[len - 1] = ' ' ;
      strcpy(list + len, *argv) ;
    }
  }

  return LPD(printer, host, &ShowQueue, lpdcmd, list) ;
}

/*
 * $Log: lpq.c,v $
 * Revision 1.3  2000/08/31 22:05:14  angus
 * Keep socket open for lpr until reply read; make reply reading routine common
 *
 * Revision 1.2  1999/10/24 05:45:30  angus
 *
 * Add support for -Z options
 * Allow printer@host syntax for all programs
 * Use SO_DONTLINGER to enable socket re-use
 *
 * Revision 1.1.1.1  1999/07/02 06:21:11  angus
 * Initial CVS import
 *
 */
