/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QPair;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSettings;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTimerEvent;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QImageReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathWalker
extends QObject {
    private static List<String> imageFormats;
    public QSignalEmitter.Signal2<String, QImage> resourceFound = new QSignalEmitter.Signal2((QSignalEmitter)this);
    public QSignalEmitter.Signal0 doneSearching = new QSignalEmitter.Signal0((QSignalEmitter)this);
    public QSignalEmitter.Signal0 beginSearching = new QSignalEmitter.Signal0((QSignalEmitter)this);
    private int timerId = 0;
    private static List<String> roots;
    private List<String> fileExtensions = imageFormats;
    private boolean stopped;
    private Stack<QPair<Object, String>> stack;
    private Set<String> processedDirs;
    private QSize size = new QSize(16, 16);

    public ClassPathWalker() {
        if (roots == null) {
            String string = System.getProperty("java.class.path");
            ArrayList<String> arrayList = new ArrayList<String>();
            Collections.addAll(arrayList, string.split(File.pathSeparator));
            ClassPathWalker.setRoots(arrayList);
            ClassPathWalker.addRootsFromSettings();
        }
    }

    protected void timerEvent(QTimerEvent qTimerEvent) {
        if (this.stopped) {
            return;
        }
        if (this.stack.isEmpty()) {
            this.kill();
            this.doneSearching.emit();
            return;
        }
        QPair<Object, String> qPair = this.stack.pop();
        if (qPair.first instanceof QDir) {
            Object object2;
            QDir qDir = (QDir)qPair.first;
            String string = QDir.toNativeSeparators((String)qDir.absolutePath());
            if (this.processedDirs.contains(string)) {
                return;
            }
            this.processedDirs.add(string);
            QDir.Filters filters = new QDir.Filters(new QDir.Filter[0]);
            filters.set((QtEnumerator[])new QDir.Filter[]{QDir.Filter.Readable});
            filters.set((QtEnumerator[])new QDir.Filter[]{QDir.Filter.Files});
            List list = qDir.entryList(this.fileExtensions, filters);
            for (Object object2 : list) {
                this.stack.push((QPair<Object, String>)new QPair((Object)new QFileInfo(qDir.absoluteFilePath((String)object2)), qPair.second));
            }
            filters.clear((QtEnumerator[])new QDir.Filter[]{QDir.Filter.Files});
            filters.set((QtEnumerator[])new QDir.Filter[]{QDir.Filter.NoDotAndDotDot});
            filters.set((QtEnumerator[])new QDir.Filter[]{QDir.Filter.Dirs});
            List list2 = qDir.entryList(filters);
            object2 = list2.iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                this.stack.push((QPair<Object, String>)new QPair((Object)new QDir(qDir.absoluteFilePath(string2)), qPair.second));
            }
        } else if (qPair.first instanceof QFileInfo) {
            QImage qImage;
            String string = ((QFileInfo)qPair.first).absoluteFilePath();
            int n = string.lastIndexOf(35) + 1;
            if ((string = string.substring(n)).startsWith("/")) {
                string = string.substring(1);
            }
            if (!(qImage = new QImage(string = "classpath:" + string)).isNull()) {
                QImage qImage2 = qImage.scaled(this.size, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
                if (qImage2.isNull()) {
                    qImage2 = qImage.scaled(this.size, Qt.AspectRatioMode.IgnoreAspectRatio, Qt.TransformationMode.SmoothTransformation);
                }
                qImage.dispose();
                if (!qImage2.isNull()) {
                    this.resourceFound.emit((Object)string, (Object)qImage2);
                }
            }
        }
    }

    public void start() {
        this.stopped = false;
        this.stack = new Stack();
        for (String string : roots) {
            if (string.equals("")) continue;
            string = "classpath:" + string + "#/";
            QDir qDir = new QDir(string);
            this.stack.push((QPair<Object, String>)new QPair((Object)qDir, (Object)qDir.absolutePath()));
        }
        this.processedDirs = new HashSet<String>();
        this.beginSearching.emit();
        this.timerId = this.startTimer(50);
    }

    public synchronized void kill() {
        if (this.timerId != 0) {
            this.killTimer(this.timerId);
        }
        this.timerId = 0;
        this.stopped = true;
    }

    public void setPixmapSize(QSize qSize) {
        this.size = qSize;
    }

    public static synchronized void addRootsFromSettings() {
        QSettings qSettings = new QSettings("Trolltech", "Qt Jambi Resource Browser");
        Object object = qSettings.value("Extra paths");
        if (roots != null && object != null && object instanceof String) {
            String[] stringArray;
            for (String string : stringArray = ((String)object).split(File.pathSeparator)) {
                if (string.equals("")) continue;
                QAbstractFileEngine.addSearchPathForResourceEngine((String)string);
                roots.add(string);
            }
        }
    }

    public static synchronized void setRoots(List<String> list) {
        roots = list;
    }

    public static synchronized List<String> roots() {
        return roots;
    }

    private void traverse(QDir qDir, String string) {
    }

    static {
        List list = QImageReader.supportedImageFormats();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QByteArray qByteArray : list) {
            if (qByteArray.toString().equals("svg")) continue;
            arrayList.add("*." + qByteArray.toString());
        }
        imageFormats = arrayList;
    }
}

