/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCompleter;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QDialogButtonBox;
import com.trolltech.qt.gui.QDirModel;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPathDialog
extends QDialog {
    private final QPixmap PIXMAP_FOLDER = new QPixmap("classpath:com/trolltech/tools/designer/classpathdir.png");
    private final QPixmap PIXMAP_ARCHIVE = new QPixmap("classpath:com/trolltech/tools/designer/classpathjar.png");
    private QLineEdit path = new QLineEdit();
    private QPushButton addButton = new QPushButton(this.tr("Add"));
    private QPushButton addDirButton = new QPushButton(this.tr("Add Directory"));
    private QPushButton addJarButton = new QPushButton(this.tr("Add .jar"));
    private QPushButton removeButton = new QPushButton(this.tr("Remove"));
    private QPushButton moveUpButton = new QPushButton(this.tr("Move  up"));
    private QPushButton moveDownButton = new QPushButton(this.tr("Move down"));
    private QListWidget list = new QListWidget();
    private QDialogButtonBox buttons = new QDialogButtonBox();
    private String previousDir = null;

    public SearchPathDialog(QWidget qWidget) {
        super(qWidget);
        this.list.setAlternatingRowColors(true);
        QDialogButtonBox.StandardButtons standardButtons = new QDialogButtonBox.StandardButtons(new QDialogButtonBox.StandardButton[0]);
        standardButtons.set((QtEnumerator[])new QDialogButtonBox.StandardButton[]{QDialogButtonBox.StandardButton.Ok});
        standardButtons.set((QtEnumerator[])new QDialogButtonBox.StandardButton[]{QDialogButtonBox.StandardButton.Cancel});
        this.buttons = new QDialogButtonBox(standardButtons, Qt.Orientation.Horizontal);
        QGridLayout qGridLayout = new QGridLayout((QWidget)this);
        qGridLayout.addWidget((QWidget)this.path, 0, 0, 1, 1);
        qGridLayout.addWidget((QWidget)this.addButton, 0, 1);
        qGridLayout.addWidget((QWidget)this.addJarButton, 1, 1);
        qGridLayout.addWidget((QWidget)this.addDirButton, 2, 1);
        qGridLayout.addWidget((QWidget)this.removeButton, 3, 1);
        qGridLayout.addWidget((QWidget)this.moveUpButton, 4, 1);
        qGridLayout.addWidget((QWidget)this.moveDownButton, 5, 1);
        qGridLayout.addWidget((QWidget)this.list, 1, 0, 6, 1);
        qGridLayout.addWidget((QWidget)this.buttons, 7, 0, 1, 2);
        this.addButton.clicked.connect((Object)this, "addPath()");
        this.addJarButton.clicked.connect((Object)this, "browseForArchive()");
        this.addDirButton.clicked.connect((Object)this, "browseForDirectory()");
        this.removeButton.clicked.connect((Object)this, "removeCurrent()");
        this.moveUpButton.clicked.connect((Object)this, "moveCurrentUp()");
        this.moveDownButton.clicked.connect((Object)this, "moveCurrentDown()");
        this.path.textChanged.connect((Object)this, "updateAddButtonState(String)");
        this.buttons.button((QDialogButtonBox.StandardButton)QDialogButtonBox.StandardButton.Ok).clicked.connect((Object)this, "accept()");
        this.buttons.button((QDialogButtonBox.StandardButton)QDialogButtonBox.StandardButton.Cancel).clicked.connect((Object)this, "reject()");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("*.jar");
        QDirModel qDirModel = new QDirModel((QObject)this);
        qDirModel.setNameFilters(arrayList);
        qDirModel.setFilter(new QDir.Filters(new QDir.Filter[]{QDir.Filter.AllDirs, QDir.Filter.Files}));
        QCompleter qCompleter = new QCompleter((QObject)this);
        qCompleter.setModel((QAbstractItemModel)qDirModel);
        qCompleter.setCaseSensitivity(Qt.CaseSensitivity.CaseInsensitive);
        this.path.setCompleter(qCompleter);
    }

    public List<String> paths() {
        int n = this.list.count();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            QListWidgetItem qListWidgetItem = this.list.item(i);
            arrayList.add(qListWidgetItem.text());
        }
        return arrayList;
    }

    public void setPaths(List<String> list) {
        this.list.reset();
        for (String string : list) {
            if (new QFileInfo(string).isDir()) {
                this.addPathEntry(string, this.PIXMAP_FOLDER);
                continue;
            }
            this.addPathEntry(string, this.PIXMAP_ARCHIVE);
        }
    }

    public void moveCurrentUp() {
        int n;
        QListWidgetItem qListWidgetItem = this.list.currentItem();
        if (qListWidgetItem != null && (n = this.list.row(qListWidgetItem)) > 0) {
            this.list.takeItem(n);
            this.list.insertItem(n - 1, qListWidgetItem);
            this.list.setCurrentItem(qListWidgetItem);
        }
    }

    public void moveCurrentDown() {
        int n;
        QListWidgetItem qListWidgetItem = this.list.currentItem();
        if (qListWidgetItem != null && (n = this.list.row(qListWidgetItem)) < this.list.count() - 1) {
            this.list.takeItem(n);
            this.list.insertItem(n + 1, qListWidgetItem);
            this.list.setCurrentItem(qListWidgetItem);
        }
    }

    public void browseForArchive() {
        QFileDialog.Filter filter = new QFileDialog.Filter("*.jar");
        String string = QFileDialog.getOpenFileName((QWidget)this, (String)"Add Java Archive", (String)this.previousDir, (QFileDialog.Filter)filter);
        this.addPathEntry(string, this.PIXMAP_ARCHIVE);
    }

    public void browseForDirectory() {
        String string = QFileDialog.getExistingDirectory((QWidget)this, (String)"Add Java Classpath Directory", (String)this.previousDir);
        this.addPathEntry(string, this.PIXMAP_FOLDER);
    }

    public void removeCurrent() {
        QListWidgetItem qListWidgetItem = this.list.currentItem();
        if (qListWidgetItem != null) {
            this.list.takeItem(this.list.row(qListWidgetItem));
        }
    }

    private QPixmap pixmapForPath(String string) {
        QFileInfo qFileInfo = new QFileInfo(string);
        if (qFileInfo.exists()) {
            if (qFileInfo.isDir()) {
                return this.PIXMAP_FOLDER;
            }
            if (qFileInfo.suffix().equals("jar")) {
                return this.PIXMAP_ARCHIVE;
            }
        }
        return null;
    }

    public void addPath() {
        String string = this.path.text();
        QPixmap qPixmap = this.pixmapForPath(string);
        if (qPixmap != null) {
            this.addPathEntry(string, qPixmap);
        }
    }

    private void updateAddButtonState(String string) {
        this.addButton.setEnabled(this.pixmapForPath(string) != null);
    }

    private void addPathEntry(String string, QPixmap qPixmap) {
        if (string.length() > 0) {
            QListWidgetItem qListWidgetItem = new QListWidgetItem(this.list);
            qListWidgetItem.setText(string);
            qListWidgetItem.setIcon(new QIcon(qPixmap));
            this.previousDir = new QFileInfo(string).absolutePath();
        }
    }

    public static void main(String[] stringArray) {
        QApplication.initialize((String[])stringArray);
        SearchPathDialog searchPathDialog = new SearchPathDialog(null);
        String string = System.getProperty("java.class.path");
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, string.split(File.pathSeparator));
        searchPathDialog.setPaths(arrayList);
        searchPathDialog.exec();
        QApplication.quit();
    }
}

