/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.sql;

import com.trolltech.qt.sql.QJdbcSqlUtil;
import com.trolltech.qt.sql.QSql;
import com.trolltech.qt.sql.QSqlDriver;
import com.trolltech.qt.sql.QSqlError;
import com.trolltech.qt.sql.QSqlField;
import com.trolltech.qt.sql.QSqlRecord;
import com.trolltech.qt.sql.QSqlResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class QJdbcSqlResult
extends QSqlResult {
    private int updateCount = 0;
    private ResultSet resultSet = null;
    private Statement statement = null;
    private Connection connection = null;
    private QSqlRecord cols = null;

    public QJdbcSqlResult(QSqlDriver db, Connection c) {
        super(db);
        this.disableGarbageCollection();
        this.connection = c;
    }

    public Object handle() {
        return this.statement;
    }

    protected Object data(int i) {
        try {
            return QJdbcSqlUtil.javaToQt(this.resultSet.getObject(i + 1));
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve data"), QSqlError.ErrorType.StatementError);
            return null;
        }
    }

    protected boolean isNull(int i) {
        try {
            this.resultSet.getObject(i + 1);
            return this.resultSet.wasNull();
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve null status"), QSqlError.ErrorType.StatementError);
            return false;
        }
    }

    protected boolean fetchPrevious() {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (!this.resultSet.previous()) {
                return false;
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to fetch previous"), QSqlError.ErrorType.StatementError);
            return false;
        }
        this.setAt(this.at() - 1);
        return true;
    }

    protected boolean fetchNext() {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (!this.resultSet.next()) {
                return false;
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to fetch next"), QSqlError.ErrorType.StatementError);
            return false;
        }
        this.setAt(this.at() + 1);
        return true;
    }

    protected boolean fetch(int i) {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (this.resultSet.absolute(i + 1)) {
                this.setAt(i);
                return true;
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to fetch row"), QSqlError.ErrorType.StatementError);
            return false;
        }
        return false;
    }

    protected boolean fetchFirst() {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (this.resultSet.first()) {
                this.setAt(0);
                return true;
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to fetch first"), QSqlError.ErrorType.StatementError);
            return false;
        }
        return false;
    }

    protected boolean fetchLast() {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (this.resultSet.last()) {
                this.setAt(this.resultSet.getRow() - 1);
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to fetch last"), QSqlError.ErrorType.StatementError);
            return false;
        }
        return false;
    }

    protected int size() {
        return -1;
    }

    protected int numRowsAffected() {
        return this.updateCount;
    }

    protected boolean reset(String query) {
        boolean executionResult;
        this.clearStatement();
        try {
            this.statement = this.isForwardOnly() ? this.connection.createStatement(1003, 1007) : this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to create statement"), QSqlError.ErrorType.StatementError);
            this.statement = null;
            return false;
        }
        try {
            executionResult = this.connection.getMetaData().supportsGetGeneratedKeys() ? this.statement.execute(query, 1) : this.statement.execute(query, 2);
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to execute query"), QSqlError.ErrorType.ConnectionError);
            this.resultSet = null;
            return false;
        }
        return this.getResultSet(executionResult);
    }

    protected boolean prepare(String query) {
        this.clearStatement();
        try {
            this.statement = this.isForwardOnly() ? this.connection.prepareStatement(query, 1003, 1008) : this.connection.prepareStatement(query);
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to prepare statement"), QSqlError.ErrorType.StatementError);
            this.statement = null;
            return false;
        }
        return true;
    }

    protected boolean exec() {
        boolean executionResult;
        if (this.statement == null || !(this.statement instanceof PreparedStatement)) {
            return false;
        }
        PreparedStatement ps = (PreparedStatement)this.statement;
        try {
            for (int i = 0; i < this.boundValueCount(); ++i) {
                ps.setObject(i + 1, QJdbcSqlUtil.qtToJava(this.boundValue(i)));
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to bind parameters"), QSqlError.ErrorType.StatementError);
            return false;
        }
        try {
            executionResult = ps.execute();
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to execute query"), QSqlError.ErrorType.ConnectionError);
            this.resultSet = null;
            return false;
        }
        return this.getResultSet(executionResult);
    }

    private final boolean getResultSet(boolean executionResult) {
        if (executionResult) {
            try {
                this.resultSet = this.statement.getResultSet();
                this.setSelect(true);
            }
            catch (SQLException ex) {
                this.setError(ex, this.tr("Unable to retrieve result set"), QSqlError.ErrorType.StatementError);
                return false;
            }
        }
        try {
            this.updateCount = this.statement.getUpdateCount();
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve number of rows affected"), QSqlError.ErrorType.StatementError);
        }
        this.setActive(true);
        this.setAt(QSql.Location.BeforeFirstRow.value());
        return true;
    }

    protected QSqlRecord record() {
        ResultSetMetaData meta;
        if (this.resultSet == null) {
            return new QSqlRecord();
        }
        if (this.cols != null) {
            return this.cols;
        }
        try {
            meta = this.resultSet.getMetaData();
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve meta data"), QSqlError.ErrorType.StatementError);
            return null;
        }
        if (meta == null) {
            return null;
        }
        this.cols = new QSqlRecord();
        try {
            for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                QSqlField f = new QSqlField(meta.getColumnName(i), QJdbcSqlUtil.javaTypeToVariantType(meta.getColumnClassName(i)));
                f.setAutoValue(meta.isAutoIncrement(i));
                f.setLength(meta.getColumnDisplaySize(i));
                f.setPrecision(meta.getPrecision(i));
                meta.isNullable(i);
                f.setRequiredStatus(QJdbcSqlUtil.toRequiredStatus(meta.isNullable(i)));
                f.setReadOnly(meta.isReadOnly(i));
                this.cols.append(f);
            }
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve metadata details"), QSqlError.ErrorType.StatementError);
            return null;
        }
        return this.cols;
    }

    protected Object lastInsertId() {
        if (this.statement == null) {
            return null;
        }
        try {
            ResultSet keys;
            ResultSet resultSet = keys = this.connection.getMetaData().supportsGetGeneratedKeys() ? this.statement.getGeneratedKeys() : null;
            if (keys == null) {
                return null;
            }
            if (!keys.next()) {
                return null;
            }
            return keys.getObject(1);
        }
        catch (SQLException ex) {
            this.setError(ex, this.tr("Unable to retrieve last insert ID"), QSqlError.ErrorType.StatementError);
            return null;
        }
    }

    protected void disposed() {
        this.reenableGarbageCollection();
        super.disposed();
    }

    private final void clearStatement() {
        this.clear();
        this.setLastError(new QSqlError());
        this.setActive(false);
        this.setSelect(false);
        this.setAt(QSql.Location.BeforeFirstRow.value());
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException ex) {
                System.err.println(ex);
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                System.err.println(ex);
            }
            this.statement = null;
        }
        this.cols = null;
        this.updateCount = -1;
    }

    private void setError(SQLException e, String driverText, QSqlError.ErrorType t) {
        this.setLastError(QJdbcSqlUtil.getError(e, driverText, t));
    }
}

