/****************************************************************************
 **
 ** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;

import java.util.*;

class LaunchableListModel extends QAbstractListModel {
    private List<Launchable> m_list = new ArrayList<Launchable>();

    public void add(Launchable l) {
        m_list.add(l);
        dataChanged.emit(createIndex(0, 0), createIndex(size() - 1, 0));
    }

    public int size() {
        return m_list.size();
    }

    public Launchable at(int i) {
        return m_list.get(i);
    }

    public Launchable at(QModelIndex index) {
        if (index == null)
            throw new ArrayIndexOutOfBoundsException("invalid index");
        return at(index.row());
    }

    // item view classes...
    @Override
    public int rowCount(QModelIndex parent) {
        return size();
    }

    @Override
    public Object data(QModelIndex index, int role) {
        if (role == Qt.ItemDataRole.DisplayRole)
            return at(index.row()).name();
        return null;
    }
};
