/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.examples;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

@QtJambiExample(name = "Digital Clock")
public class DigitalClock extends QLCDNumber
{
    public DigitalClock()
    {
        setSegmentStyle(SegmentStyle.Filled);

        QTimer timer = new QTimer(this);
        timer.timeout.connect(this, "showTime()");
        timer.start(1000);

        showTime();

        setWindowTitle(tr("Digital Clock"));
        resize(150, 60);
    }

    public void showTime()
    {
        QTime time = QTime.currentTime();
        StringBuffer text = new StringBuffer(time.toString("hh:mm"));
        if ((time.second() % 2) == 0)
            text.setCharAt(2, ' ');
        display(text.toString());
    }

    public static void main(String args[])
    {
        QApplication.initialize(args);

        new DigitalClock().show();

        QApplication.exec();
    }
}
