/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNodeList;
import com.trolltech.tools.designer.CustomWidget;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomWidgetManager {
    private List<CustomWidget> customWidgets = new ArrayList<CustomWidget>();
    private List<String> warnings = new ArrayList<String>();
    private static CustomWidgetManager instance;

    private CustomWidgetManager() {
        this.loadPlugins();
    }

    public static CustomWidgetManager instance() {
        if (instance == null) {
            instance = new CustomWidgetManager();
        }
        return instance;
    }

    public List<CustomWidget> customWidgets() {
        return this.customWidgets;
    }

    private void splitIntoList(String string, List<String> list) {
        if (string != null) {
            Collections.addAll(list, string.split(File.pathSeparator));
        }
    }

    private void loadPlugins() {
        this.warnings.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.splitIntoList(System.getenv("QT_PLUGIN_PATH"), arrayList);
        this.splitIntoList(System.getProperty("com.trolltech.qt.plugin-path"), arrayList);
        for (String object : arrayList) {
            this.loadPluginsFromPath(object + "/qtjambi");
        }
        if (this.warnings.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.warnings) {
                stringBuilder.append(string).append("\n");
            }
            QMessageBox.warning(null, (String)"Custom widgets loading!", (String)stringBuilder.toString());
        }
    }

    private void loadPlugins(String string) {
        this.customWidgets.clear();
        String[] stringArray = string.split(System.getProperty("path.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            this.loadPluginsFromPath(stringArray[i]);
        }
    }

    private void loadPluginsFromPath(String string) {
        QDir qDir = new QDir(string);
        if (!new QFileInfo(qDir.absolutePath()).exists()) {
            this.warn("CustomWidgetManager: plugin path doesn't exist: " + string);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("*.xml");
        List list = qDir.entryInfoList(arrayList);
        for (QFileInfo qFileInfo : list) {
            this.loadPlugin(qFileInfo.absoluteFilePath());
        }
    }

    private void loadPlugin(String string) {
        QDomDocument qDomDocument = new QDomDocument();
        qDomDocument.setContent((QIODevice)new QFile(string));
        QDomElement qDomElement = qDomDocument.firstChild().toElement();
        QDomNodeList qDomNodeList = qDomElement.childNodes();
        for (int i = 0; i < qDomNodeList.size(); ++i) {
            String string2 = string + " : entry " + (i + 1);
            QDomElement qDomElement2 = qDomNodeList.at(i).toElement();
            String string3 = qDomElement2.attribute("class");
            if (string3.length() == 0) {
                this.warn(string2 + "; missing 'class' attribute");
                continue;
            }
            try {
                QIcon qIcon;
                Object object;
                String string4;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(qDomElement2.attribute("class"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        string4 = System.getProperty("com.trolltech.qtjambi.internal.current.classpath");
                        if (string4 != null) {
                            object = string4.split(";");
                            qIcon = new URL[((String[])object).length];
                            for (int j = 0; j < ((String[])object).length; ++j) {
                                qIcon[j] = new URL(object[j]);
                            }
                            URLClassLoader uRLClassLoader = new URLClassLoader((URL[])qIcon, this.getClass().getClassLoader());
                            clazz = uRLClassLoader.loadClass(qDomElement2.attribute("class"));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
                if (clazz == null) continue;
                CustomWidget customWidget = new CustomWidget(clazz);
                this.customWidgets.add(customWidget);
                string4 = qDomElement2.attribute("group");
                if (string4.length() == 0) {
                    string4 = "Qt Jambi Custom Widgets";
                }
                customWidget.setGroup(string4);
                customWidget.setTooltip(qDomElement2.attribute("tool-tip"));
                customWidget.setWhatsThis(qDomElement2.attribute("whats-this"));
                customWidget.setName(qDomElement2.attribute("name"));
                customWidget.setIncludeFile(qDomElement2.attribute("import"));
                object = qDomElement2.attribute("icon");
                qIcon = null;
                if (((String)object).length() != 0 && (qIcon = new QIcon((String)object)).isNull()) {
                    this.warn(string2 + "; icon '" + (String)object + "' not loaded");
                    qIcon = null;
                }
                customWidget.setIcon(qIcon);
                boolean bl = false;
                String string5 = qDomElement2.attribute("container");
                if (string5 != null) {
                    bl = (string5 = string5.toLowerCase()).equals("yes") || string5.equals("true");
                }
                customWidget.setContainer(bl);
                continue;
            }
            catch (Exception exception) {
                this.warn("class=" + string3 + ", file=" + string + ", error=" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void warn(String string) {
        this.warnings.add(string);
    }

    public static void main(String[] stringArray) {
        QApplication.initialize((String[])stringArray);
        List<CustomWidget> list = CustomWidgetManager.instance().customWidgets();
        for (CustomWidget customWidget : list) {
            customWidget.createWidget(null).show();
        }
        QApplication.exec();
    }
}

