/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "gameanimation.h"

GameAnimation::GameAnimation(Game::AnimationType type) 
    : m_type(type), m_speed(0), m_looping(false), m_current_frame(0)
{
}

GameAnimation::~GameAnimation()
{
}

bool GameAnimation::update()
{
    int elapsed = m_time.elapsed();
    if (m_speed > 0 && !m_frames.isEmpty()) {
        int frames = int(elapsed / double(m_speed));       

        if (!m_looping && frames + m_current_frame >= m_frames.size())
            m_current_frame = m_frames.size() - 1;
        else
            m_current_frame = (m_current_frame + frames) % m_frames.size();
        
        if (frames > 0) {
            m_time.restart();
            return true;
        }
    }
    return false;
}
