/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNodeList;
import com.trolltech.tools.designer.CustomWidget;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomWidgetManager {
    private List<CustomWidget> customWidgets = new ArrayList<CustomWidget>();
    private List<String> warnings = new ArrayList<String>();
    private static CustomWidgetManager instance;

    private CustomWidgetManager() {
        this.loadPlugins();
    }

    public static CustomWidgetManager instance() {
        if (instance == null) {
            instance = new CustomWidgetManager();
        }
        return instance;
    }

    public List<CustomWidget> customWidgets() {
        return this.customWidgets;
    }

    private void splitIntoList(String string, List<String> list) {
        if (string != null) {
            Collections.addAll(list, string.split(File.pathSeparator));
        }
    }

    private void loadPlugins() {
        this.warnings.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.splitIntoList(System.getenv("QT_PLUGIN_PATH"), arrayList);
        this.splitIntoList(System.getProperty("com.trolltech.qt.plugin-path"), arrayList);
        for (String object : arrayList) {
            this.loadPluginsFromPath(object + "/qtjambi");
        }
        if (this.warnings.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.warnings) {
                stringBuilder.append(string).append("\n");
            }
            QMessageBox.warning(null, "Custom widgets loading!", stringBuilder.toString());
        }
    }

    private void loadPlugins(String string) {
        this.customWidgets.clear();
        String[] stringArray = string.split(System.getProperty("path.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            this.loadPluginsFromPath(stringArray[i]);
        }
    }

    private void loadPluginsFromPath(String string) {
        QDir qDir = new QDir(string);
        if (!new QFileInfo(qDir.absolutePath()).exists()) {
            this.warn("CustomWidgetManager: plugin path doesn't exist: " + string);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("*.xml");
        List<QFileInfo> list = qDir.entryInfoList(arrayList);
        for (QFileInfo qFileInfo : list) {
            this.loadPlugin(qFileInfo.absoluteFilePath());
        }
    }

    private void loadPlugin(String string) {
        QDomDocument qDomDocument = new QDomDocument();
        qDomDocument.setContent(new QFile(string));
        QDomElement qDomElement = qDomDocument.firstChild().toElement();
        QDomNodeList qDomNodeList = qDomElement.childNodes();
        for (int i = 0; i < qDomNodeList.size(); ++i) {
            String string2 = string + " : entry " + (i + 1);
            QDomElement qDomElement2 = qDomNodeList.at(i).toElement();
            String string3 = qDomElement2.attribute("class");
            if (string3.length() == 0) {
                this.warn(string2 + "; missing 'class' attribute");
                continue;
            }
            try {
                boolean bl;
                Object object;
                Object object2;
                String string4;
                Class<?> clazz;
                block11: {
                    clazz = null;
                    try {
                        clazz = Class.forName(qDomElement2.attribute("class"));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string4 = System.getProperty("com.trolltech.qtjambi.internal.current.classpath");
                        if (string4 == null) break block11;
                        object2 = string4.split(";");
                        object = new URL[((String[])object2).length];
                        for (bl = false; bl < ((String[])object2).length; bl += 1) {
                            object[bl] = new URL(object2[bl]);
                        }
                        URLClassLoader uRLClassLoader = new URLClassLoader((URL[])object, this.getClass().getClassLoader());
                        clazz = uRLClassLoader.loadClass(qDomElement2.attribute("class"));
                    }
                }
                if (clazz == null) {
                    throw new NullPointerException("Failed to load class: " + string3);
                }
                CustomWidget customWidget = new CustomWidget(clazz);
                this.customWidgets.add(customWidget);
                string4 = qDomElement2.attribute("group");
                if (string4.length() == 0) {
                    string4 = "Qt Jambi Custom Widgets";
                }
                customWidget.setGroup(string4);
                customWidget.setTooltip(qDomElement2.attribute("tool-tip"));
                customWidget.setWhatsThis(qDomElement2.attribute("whats-this"));
                customWidget.setName(qDomElement2.attribute("name"));
                customWidget.setIncludeFile(qDomElement2.attribute("import"));
                object2 = qDomElement2.attribute("icon");
                object = null;
                if (((String)object2).length() != 0 && ((QIcon)(object = new QIcon((String)object2))).isNull()) {
                    this.warn(string2 + "; icon '" + (String)object2 + "' not loaded");
                    object = null;
                }
                customWidget.setIcon((QIcon)object);
                bl = false;
                String string5 = qDomElement2.attribute("container");
                if (string5 != null) {
                    bl = (string5 = string5.toLowerCase()).equals("yes") || string5.equals("true");
                }
                customWidget.setContainer(bl);
                continue;
            }
            catch (Exception exception) {
                this.warn("class=" + string3 + ", file=" + string + ", error=" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void warn(String string) {
        this.warnings.add(string);
    }

    public static void main(String[] stringArray) {
        QApplication.initialize(stringArray);
        List<CustomWidget> list = CustomWidgetManager.instance().customWidgets();
        for (CustomWidget customWidget : list) {
            customWidget.createWidget(null).show();
        }
        QApplication.exec();
    }
}

