/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMEGRAMMAR_H
#define GAMEGRAMMAR_H

#include <QtCore/QString>
#include <QtCore/QHash>
#include <QtCore/QStringList>

class GameScene ;
class GameAction ;
class AbstractGameObject ;

class GameGrammar
{
public:
    GameGrammar(GameScene *scene);
    virtual ~GameGrammar();

    void registerGameObject(AbstractGameObject *gameObject);
    void addNameToGameObject(AbstractGameObject *gameObject, const QString &other_name);
    void addVerb(const QString &verb, GameAction *action)
    {
        m_actions[verb] = action;
    }

    virtual void parse(const QString &command);

protected:
    virtual GameAction *command();
    virtual GameAction *verb();
    virtual AbstractGameObject *object();
    
    virtual bool filler();
    virtual bool and_token();
    virtual QString currentToken(int token_count = 1) const;
    virtual void nextToken();

    QHash<QString, AbstractGameObject *> m_objects;
    QHash<QString, GameAction *> m_actions;
    GameScene *m_scene;
    QStringList m_current_command;
};

#endif
