/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtBlockedSlot;
import com.trolltech.qt.QtJambiObject;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.tools.designer.JambiMemberSheet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberSheet
extends JambiMemberSheet {
    private List<Entry> entries;
    private QObject object;
    private static HashMap<String, String> typeMap = new HashMap();
    private static HashSet<Class> blockedSlotClasses;

    public MemberSheet(QObject qObject, QObject qObject2) {
        super(qObject2);
        this.object = qObject;
        this.build();
    }

    @Override
    public int count() {
        return this.entries.size();
    }

    @Override
    public String declaredInClass(int n) {
        if (n >= this.entries.size()) {
            return null;
        }
        return this.entries.get(n).group();
    }

    @Override
    public int indexOf(String string) {
        return 0;
    }

    @Override
    public boolean inheritedFromWidget(int n) {
        if (n >= this.entries.size()) {
            return false;
        }
        return this.entries.get(n).isWidget();
    }

    @Override
    public boolean isSignal(int n) {
        if (n >= this.entries.size()) {
            return false;
        }
        return !(this.entries.get(n) instanceof SlotEntry);
    }

    @Override
    public boolean isSlot(int n) {
        if (n >= this.entries.size()) {
            return false;
        }
        return this.entries.get(n) instanceof SlotEntry;
    }

    @Override
    public boolean isVisible(int n) {
        if (n >= this.entries.size()) {
            return false;
        }
        return this.entries.get(n).visible();
    }

    @Override
    public String memberGroup(int n) {
        if (n >= this.entries.size()) {
            return null;
        }
        return this.entries.get(n).group();
    }

    @Override
    public String memberName(int n) {
        if (n >= this.entries.size()) {
            return null;
        }
        return this.entries.get(n).name();
    }

    @Override
    public List<QByteArray> parameterNames(int n) {
        return null;
    }

    @Override
    public List<QByteArray> parameterTypes(int n) {
        return null;
    }

    @Override
    public void setMemberGroup(int n, String string) {
    }

    @Override
    public void setVisible(int n, boolean bl) {
        if (n >= this.entries.size()) {
            this.entries.get(n).setVisible(bl);
        }
    }

    @Override
    public String signature(int n) {
        return this.entries.get(n).signature();
    }

    public static boolean signalMatchesSlot(String string, String string2) {
        if (string.equals("<signal>") || string2.equals("<slot>") || string.length() == 0 || string2.length() == 0) {
            return true;
        }
        if (string2.contains("()")) {
            return true;
        }
        int n = string.indexOf(60);
        if (n < 0) {
            return false;
        }
        int n2 = string2.indexOf(40);
        if (n2 < 0) {
            throw new IllegalArgumentException("slot doesn't contain () as expected, '" + string2 + "'");
        }
        String[] stringArray = string.substring(n + 1, string.length() - 1).split(",");
        String[] stringArray2 = string2.substring(n2 + 1, string2.length() - 1).split(",");
        if (stringArray2.length > stringArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (MemberSheet.matchTypes(stringArray[i], stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTypes(String string, String string2) {
        return string.equals(string2) || typeMap.get(string) != null && typeMap.get(string).equals(string2);
    }

    private void build(Class clazz, List<Entry> list) {
        this.buildSlots(clazz, list);
        this.buildSignals(clazz, list);
    }

    private static boolean shouldReject(Method method) {
        if (method.isAnnotationPresent(QtBlockedSlot.class)) {
            return true;
        }
        int n = method.getModifiers();
        if (Modifier.isStatic(n)) {
            return true;
        }
        if (blockedSlotClasses.contains(method.getDeclaringClass())) {
            return true;
        }
        String string = method.getName();
        if (string.startsWith("__qt_")) {
            return true;
        }
        if (string.endsWith("Event")) {
            return true;
        }
        return string.equals("event") || string.equals("eventFilter");
    }

    private void buildSlots(Class clazz, List<Entry> list) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (MemberSheet.shouldReject(method)) continue;
            SlotEntry slotEntry = new SlotEntry();
            slotEntry.method = method;
            list.add(slotEntry);
        }
    }

    private static boolean shouldReject(Field field) {
        return !QSignalEmitter.AbstractSignal.class.isAssignableFrom(field.getType());
    }

    private void buildSignals(Class clazz, List<Entry> list) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getFields()) {
            if (MemberSheet.shouldReject(field)) continue;
            SignalEntry signalEntry = new SignalEntry();
            signalEntry.signal = field;
            list.add(signalEntry);
        }
    }

    private void build() {
        Class<?> clazz = this.object.getClass();
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        this.build(clazz, arrayList);
        this.entries = arrayList;
    }

    static {
        typeMap.put("java.lang.Boolean", "boolean");
        typeMap.put("java.lang.Byte", "byte");
        typeMap.put("java.lang.Char", "char");
        typeMap.put("java.lang.Short", "short");
        typeMap.put("java.lang.Integer", "int");
        typeMap.put("java.lang.Long", "long");
        typeMap.put("java.lang.Float", "float");
        typeMap.put("java.lang.Double", "double");
        blockedSlotClasses = new HashSet();
        blockedSlotClasses.add(QtJambiObject.class);
        blockedSlotClasses.add(QSignalEmitter.class);
        blockedSlotClasses.add(Object.class);
    }

    private static class SlotEntry
    extends Entry {
        Method method;

        private SlotEntry() {
        }

        public String group() {
            return this.method.getDeclaringClass().getName();
        }

        public String name() {
            return this.method.getName();
        }

        public String signature() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.method.getName());
            stringBuilder.append("(");
            Class<?>[] classArray = this.method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(classArray[i].getName());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public boolean isWidget() {
            return this.method.getDeclaringClass() == QWidget.class;
        }
    }

    private static class SignalEntry
    extends Entry {
        Field signal;

        private SignalEntry() {
        }

        public String name() {
            return this.signal.getName();
        }

        public String signature() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.signal.getName());
            Type type = this.signal.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                if (typeArray.length > 0) {
                    stringBuilder.append("<");
                }
                for (int i = 0; i < typeArray.length; ++i) {
                    Class clazz = (Class)typeArray[i];
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(clazz.getName());
                }
                if (typeArray.length > 0) {
                    stringBuilder.append(">");
                }
            }
            return stringBuilder.toString();
        }

        public String group() {
            return this.signal.getDeclaringClass().getName();
        }

        public boolean isWidget() {
            return this.signal.getDeclaringClass() == QWidget.class;
        }
    }

    private static abstract class Entry {
        private boolean visible = true;

        private Entry() {
        }

        public abstract String name();

        public abstract String signature();

        public abstract String group();

        public abstract boolean isWidget();

        public boolean visible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }
    }
}

