/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QGUISIGNALMAPPER_H
#define QGUISIGNALMAPPER_H

#include <QtCore/QObject>
#include <QtCore/QSignalMapper>

class QGuiSignalMapper: public QSignalMapper
{
    Q_OBJECT
public:
    QGuiSignalMapper();
    QGuiSignalMapper(QObject *parent);

    void setMapping(QObject *sender, QWidget *widget);
    QObject *mapping(QWidget *widget) const;

private slots:
    void emitMapped(QWidget *);
    void emitMappedQWidget(QWidget *);

signals:
    void mappedQWidget(QWidget *widget);

private:
    void init();

    uint emittingMapped : 1;
    uint emittingMappedQWidget : 1;

};

#endif // QGUISIGNALMAPPER_H
