/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qguisignalmapper.h"

QGuiSignalMapper::QGuiSignalMapper() : QSignalMapper()
{
    init();
}

QGuiSignalMapper::QGuiSignalMapper(QObject *parent) : QSignalMapper(parent)
{
    init();
}

void QGuiSignalMapper::emitMapped(QWidget *widget)
{
    // Make sure we emit mapped() exactly once for each emission of mappedQWidget()
    if (!emittingMapped) {
        emittingMapped = true;
        emit mapped(widget);
        emittingMapped = false;
    }
}

void QGuiSignalMapper::emitMappedQWidget(QWidget *widget)
{
    // Make sure we emit mappedQWidget() exactly once for each emission of mapped()
    if (!emittingMappedQWidget) {
        emittingMappedQWidget = true;
        emit mappedQWidget(widget);
        emittingMappedQWidget = false;
    }
}

void QGuiSignalMapper::init()
{
    // mappedQWidget is a replacement for the original signal
    connect(this, SIGNAL(mappedQWidget(QWidget *)), this, SLOT(emitMapped(QWidget*)));
    connect(this, SIGNAL(mapped(QWidget *)), this, SLOT(emitMappedQWidget(QWidget*)));

    emittingMappedQWidget = false;
    emittingMapped = false;
}

void QGuiSignalMapper::setMapping(QObject *sender, QWidget *widget)
{
    QSignalMapper::setMapping(sender, widget);
}

QObject *QGuiSignalMapper::mapping(QWidget *widget) const
{
    return QSignalMapper::mapping(widget);
}
