/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "gameanimation.h"

GameAnimation::GameAnimation(Game::AnimationType type)
    : m_type(type), m_speed(0), m_looping(false), m_current_frame(0)
{
}

GameAnimation::~GameAnimation()
{
}

bool GameAnimation::update()
{
    int elapsed = m_time.elapsed();
    if (m_speed > 0 && !m_frames.isEmpty()) {
        int frames = int(elapsed / double(m_speed));

        if (!m_looping && frames + m_current_frame >= m_frames.size())
            m_current_frame = m_frames.size() - 1;
        else
            m_current_frame = (m_current_frame + frames) % m_frames.size();

        if (frames > 0) {
            m_time.restart();
            return true;
        }
    }
    return false;
}
