/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef TYPEPARSER_H
#define TYPEPARSER_H

#include <QList>
#include <QString>
#include <QStringList>

class TypeParser
{
public:
    struct Info
    {
        Info() : is_reference(false), is_constant(false), is_busted(false), indirections(0) { }
        QStringList qualified_name;
        QStringList arrays;
        QList<Info> template_instantiations;
        uint is_reference : 1;
        uint is_constant : 1;
        uint is_busted : 1;
        uint indirections : 5;

        QString toString() const;
        QString instantiationName() const;
    };

    static Info parse(const QString &str);
};

#endif // TYPEPARSER_H
