/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef METAJAVABUILDER_H
#define METAJAVABUILDER_H

#include "abstractmetabuilder.h"
#include "metajava.h"

class MetaJavaBuilder : public AbstractMetaBuilder
{

 protected:
    virtual MetaJavaClass *createMetaClass()
        {
            return new MetaJavaClass();
        };

    virtual MetaJavaEnum *createMetaEnum()
        {
            return new MetaJavaEnum();
        };

    virtual MetaJavaEnumValue *createMetaEnumValue()
        {
            return new MetaJavaEnumValue();
        };

    virtual MetaJavaField *createMetaField()
        {
            return new MetaJavaField();
        };

    virtual MetaJavaFunction *createMetaFunction()
        {
            return new MetaJavaFunction();
        };

    virtual MetaJavaArgument *createMetaArgument()
        {
            return new MetaJavaArgument();
        };

    virtual MetaJavaType *createMetaType()
        {
            return new MetaJavaType();
        };

};

#endif // METAJAVABUILDER_H
