/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GENERATOR_SET_H
#define GENERATOR_SET_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QMap>

class GeneratorSet : public QObject
{
    Q_OBJECT

 public:
    GeneratorSet();

    virtual QString usage() = 0;
    virtual bool readParameters(const QMap<QString, QString> args) = 0;
    virtual void buildModel(const QString pp_file) = 0;
    virtual void dumpObjectTree() = 0;
    virtual QString generate() = 0;

    static GeneratorSet *getInstance();
    QString outDir;
    bool printStdout;
};

#endif // GENERATOR_SET_H
