/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef CPP_HEADER_GENERATOR
#define CPP_HEADER_GENERATOR

#include "cppgenerator.h"
#include "metajava.h"

class CppHeaderGenerator : public CppGenerator
{
    Q_OBJECT

public:
    CppHeaderGenerator(PriGenerator *pri)
    {
        priGenerator = pri;
    }

    virtual QString fileNameForClass(const AbstractMetaClass *cls) const;

    void write(QTextStream &s, const AbstractMetaClass *java_class);
    void writeFunction(QTextStream &s, const AbstractMetaFunction *java_function);
    void writePublicFunctionOverride(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeVirtualFunctionOverride(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeForwardDeclareSection(QTextStream &s, const AbstractMetaClass *java_class);
    void writeVariablesSection(QTextStream &s, const AbstractMetaClass *java_class);
    void writeFieldAccessors(QTextStream &s, const AbstractMetaField *java_field);
    void writeSignalWrapper(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeSignalWrappers(QTextStream &s, const AbstractMetaClass *java_class);
    void writeWrapperClass(QTextStream &s, const AbstractMetaClass *java_class);
    void writeInjectedCode(QTextStream &s, const AbstractMetaClass *java_class);

    bool shouldGenerate(const AbstractMetaClass *java_class) const {
        return (java_class->generateShellClass()
                && CppGenerator::shouldGenerate(java_class))
            || (java_class->queryFunctions(AbstractMetaClass::Signals).size() > 0
                && (java_class->typeEntry()->codeGeneration() & TypeEntry::GenerateCpp));
    }
};

#endif // CPP_HEADER_GENERATOR
