/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt.core;


/**
 * The QInvokable class is used internally by QCoreApplication.invokeLater()
 * to execute a java.lang.Runnable from the gui-thread.
 *
 * @see QCoreApplication
 */
class QInvokable extends QObject {

    static QEvent.Type INVOKABLE_EVENT = QEvent.Type.resolve(QEvent.Type.User.value() + 1);

    QInvokable(Runnable r) {
        disableGarbageCollection();
        if(QCoreApplication.instance() != null && QCoreApplication.instance().nativeId() != 0) {
            moveToThread(QCoreApplication.instance().thread());
            runnable = r;
        }
    }

    public final boolean event(com.trolltech.qt.core.QEvent e) {
        if (e.type() == INVOKABLE_EVENT && runnable != null) {
            runnable.run();
            disposeLater();
            return true;
        }
        return super.event(e);
    }

    private Runnable runnable;
}
