/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * QtPropertyDesignable specifies whether a proprety
 * is suitable for editing in a GUI builder (e.g. the Qt Designer). The default is true.
 * This annotation should be used with the read method of the property.
 *
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface QtPropertyDesignable {
    /**
     * The value should be true or false depending on whether the
     * property is designable. It can also be the name of a boolean
     * method in the same class as the annotated method; it must
     * return true if the property is to be designable; otherwise,
     * false.
     */
    String value() default "true";
}
