/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * Information about a property in a QObject subclass.
 */
public class QtProperty {
    private final boolean writable;
    private final boolean designable;
    private final boolean resettable;
    private final boolean user;
    private final String name;

    QtProperty(boolean writable, boolean designable, boolean resettable, boolean user, String name) {
        this.writable = writable;
        this.designable = designable;
        this.resettable = resettable;
        this.user = user;
        this.name = name;
    }

    public final boolean isWritable() { return writable; }
    public final boolean isResettable() { return resettable; }
    public final boolean isDesignable() { return designable; }
    public final boolean isUser() { return user; }
    public final String name() { return name; }

    @Override
    public final String toString() {
        return name;
    }
}
