/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * @exclude
 */
class QThreadManager {

    private static class NativeResourcesReleaseThread extends Thread {
        private int m_sleepTime = 100;

        public NativeResourcesReleaseThread() {
            setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try { sleep(m_sleepTime); } catch (Exception e) { };
                boolean release = releaseNativeResources();
                m_sleepTime = release ? 100 : Math.min(m_sleepTime * 2, 60 * 1000);
            }
        }
    }

    public static void initialize() {
        new NativeResourcesReleaseThread().start();
    }

    public synchronized static native boolean releaseNativeResources();
}
