/****************************************************************************
 **
 ** Copyright (C) 1992-2009 Nokia. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;

import java.util.*;

class LaunchableListModel extends QAbstractListModel {
    private List<Launchable> m_list = new ArrayList<Launchable>();

    public void add(Launchable l) {
        m_list.add(l);
        dataChanged.emit(createIndex(0, 0), createIndex(size() - 1, 0));
    }

    public int size() {
        return m_list.size();
    }

    public Launchable at(int i) {
        return m_list.get(i);
    }

    public Launchable at(QModelIndex index) {
        if (index == null)
            throw new ArrayIndexOutOfBoundsException("invalid index");
        return at(index.row());
    }

    // item view classes...
    @Override
    public int rowCount(QModelIndex parent) {
        return size();
    }

    @Override
    public Object data(QModelIndex index, int role) {
        if (role == Qt.ItemDataRole.DisplayRole)
            return at(index.row()).name();
        return null;
    }
};
