/****************************************************************************
 **
 **  (C) 1992-2009 Nokia. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.examples;

import com.trolltech.qt.core.*;
import com.trolltech.qt.core.Qt.*;
import com.trolltech.qt.gui.*;
import com.trolltech.qt.gui.QSizePolicy.Policy;

@QtJambiExample(name = "Screenshot")
//! [0]
public class Screenshot extends QWidget {
//! [0]

//! [1]
    public static void main(String args[]) {
        QApplication.initialize(args);
        Screenshot screenshot = new Screenshot(null);
        screenshot.show();
        QApplication.exec();
    }
//! [1]

//! [2]
    volatile QPixmap originalPixmap;

    QLabel screenshotLabel;
    QGroupBox optionsGroupBox;
    QSpinBox delaySpinBox;
    QLabel delaySpinBoxLabel;
    QCheckBox hideThisWindowCheckBox;
    QPushButton newScreenshotButton;
    QPushButton saveScreenshotButton;
    QPushButton quitScreenshotButton;

    QVBoxLayout mainLayout;
    QGridLayout optionsGroupBoxLayout;
    QHBoxLayout buttonsLayout;

    public Screenshot(QWidget parent) {
        super(parent);
        screenshotLabel = new QLabel();
        screenshotLabel.setSizePolicy(Policy.Expanding, Policy.Expanding);
        screenshotLabel.setAlignment(AlignmentFlag.AlignCenter);
        screenshotLabel.setMinimumSize(240, 160);

        createOptionsGroupBox();
        createButtonsLayout();

        mainLayout = new QVBoxLayout();
        mainLayout.addWidget(screenshotLabel);
        mainLayout.addWidget(optionsGroupBox);
        mainLayout.addLayout(buttonsLayout);
        setLayout(mainLayout);

        shootScreen();
        delaySpinBox.setValue(5);

        setWindowIcon(new QIcon("classpath:com/trolltech/images/qt-logo.png"));
        setWindowTitle(tr("Screenshot"));
        resize(300, 200);
    }
//! [2]

    @Override
//! [3]
    public void resizeEvent(QResizeEvent event) {
        QSize scaledSize = originalPixmap.size();
        scaledSize.scale(screenshotLabel.size(),
                         AspectRatioMode.KeepAspectRatio);
        if (screenshotLabel.pixmap() != null
            || scaledSize != screenshotLabel.pixmap().size())
                updateScreenshotLabel();
    }
//! [3]

//! [4]
    void newScreenshot() {
        if (hideThisWindowCheckBox.isChecked())
            hide();
        newScreenshotButton.setDisabled(true);

        QTimer.singleShot(delaySpinBox.value() * 1000,
                          this, "shootScreen()");
    }
//! [4]

//! [5]
    void saveScreenshot() {
        String format = "png";
        String initialPath = QDir.currentPath() + tr("/untitled.") + format;
        String filter = String.format(tr("%1$s Files (*.%2$s);;All Files (*)"),
                                      format.toUpperCase(), format);
        String fileName;
        fileName = QFileDialog.getSaveFileName(this, tr("Save As"), initialPath,
                                               new QFileDialog.Filter(filter));

        if (!fileName.equals(""))
            originalPixmap.save(fileName, format);
    }
//! [5]

//! [6]
    void shootScreen() {
        if (delaySpinBox.value() != 0)
            QApplication.beep();
//! [6]

//! [7]
        originalPixmap = null;

        originalPixmap = QPixmap.grabWindow(
                QApplication.desktop().winId());
        updateScreenshotLabel();

        newScreenshotButton.setDisabled(false);
        if (hideThisWindowCheckBox.isChecked())
            show();
    }
//! [7]

//! [8]
    void updateCheckBox() {
        if (delaySpinBox.value() == 0)
            hideThisWindowCheckBox.setDisabled(true);
        else
            hideThisWindowCheckBox.setDisabled(false);
    }
//! [8]

//! [9]
    void createOptionsGroupBox() {
        optionsGroupBox = new QGroupBox(tr("Options"));

        delaySpinBox = new QSpinBox();
        delaySpinBox.setSuffix(tr(" s"));
        delaySpinBox.setMaximum(60);
        delaySpinBox.valueChanged.connect(this, "updateCheckBox()");

        delaySpinBoxLabel = new QLabel(tr("Screenshot Delay:"));

        hideThisWindowCheckBox = new QCheckBox(tr("Hide This Window"));

        optionsGroupBoxLayout = new QGridLayout();
        optionsGroupBoxLayout.addWidget(delaySpinBoxLabel, 0, 0);
        optionsGroupBoxLayout.addWidget(delaySpinBox, 0, 1);
        optionsGroupBoxLayout.addWidget(hideThisWindowCheckBox, 1, 0, 1, 2);
        optionsGroupBox.setLayout(optionsGroupBoxLayout);
    }
//! [9]

//! [10]
    void createButtonsLayout() {
        newScreenshotButton = createButton(tr("New Screenshot"), this,
                                           "newScreenshot()");

        saveScreenshotButton = createButton(tr("Save Screenshot"), this,
                                            "saveScreenshot()");

        quitScreenshotButton = createButton(tr("Quit"), this, "close()");

        buttonsLayout = new QHBoxLayout();
        buttonsLayout.addStretch();
        buttonsLayout.addWidget(newScreenshotButton);
        buttonsLayout.addWidget(saveScreenshotButton);
        buttonsLayout.addWidget(quitScreenshotButton);
    }
//! [10]

//! [11]
    QPushButton createButton(final String text, QWidget receiver,
                             String member) {
        QPushButton button = new QPushButton(text);
        button.clicked.connect(receiver, member);
        return button;
    }
//! [11]

//! [12]
    void updateScreenshotLabel() {
        screenshotLabel.setPixmap(originalPixmap.scaled(screenshotLabel.size(),
                                  AspectRatioMode.KeepAspectRatio,
                                  TransformationMode.SmoothTransformation));
    }
//! [12] //! [13]
}
//! [13]
