/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTJAMBITREEMODEL_H
#define QTJAMBITREEMODEL_H

#include <QtCore/QAbstractItemModel>
#include <QtCore/QHash>
#include <QtCore/QVariant>

#include <qtjambi_global.h>

class Node;

struct JObject_key {
    jobject obj;
    uint hashCode;
};

uint qHash(const JObject_key &key);
bool operator==(const JObject_key &a, const JObject_key &b);

class QTreeModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    QTreeModel(QObject *parent = 0);

    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &) const;
    QModelIndex index(int row, int, const QModelIndex &parent) const;
    QModelIndex parent(const QModelIndex &index) const;
    QVariant data(const QModelIndex &index, int role) const;

    jobject indexToValue(const QModelIndex &index) const;
    QModelIndex valueToIndex(jobject object) const;

    void childrenRemoved(const QModelIndex &parent, int first, int last);
    void childrenInserted(const QModelIndex &parent, int first, int last);

    virtual int childCount(jobject parent) const = 0;
    virtual jobject child(jobject parent, int index) const = 0;

    virtual QVariant data(jobject value, int role) const;
    virtual QIcon icon(jobject value) const;
    virtual QString text(jobject value) const = 0;

public slots:
    void releaseChildren(const QModelIndex &index);

private slots:
    void wasReset();
    void wasChanged();

private:
    void initializeNode(Node *n, const QModelIndex &index) const;
    void queryChildren(Node *parentNode, int start = -1, int length = -1) const;
    Node *node(const QModelIndex &index) const;
    Node *node(jobject object) const;

    QHash<JObject_key, Node *> m_nodes;
    Node *m_root;
    uint m_invalidation : 1;
};


#endif
