/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qtjambilink.h"
#include "qtjambi_core.h"
#include "qtjambitypemanager_p.h"

#include <QtCore/QVariant>
#include <QtCore/QPoint>
#include <QtCore/QPointF>
#include <QtCore/QSize>
#include <QtCore/QSizeF>
#include <QtCore/QDateTime>
#include <QtCore/QDate>
#include <QtCore/QTime>
#include <QtCore/QLine>
#include <QtCore/QLineF>
#include <QtCore/QRegExp>
#include <QtCore/QRect>
#include <QtCore/QRectF>
#include <QtCore/QStringList>
#include <QtCore/QLocale>
#include <QtCore/QChar>
#include <QtCore/QBitArray>
#include <QtCore/QByteArray>

extern "C" Q_DECL_EXPORT jobject JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1convert)
    (JNIEnv *env, jclass, jint type, jobject object)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    if (v.convert(QVariant::Type(type)))
        return qtjambi_from_qvariant(env, v);
    else
        return 0;
}

extern "C" Q_DECL_EXPORT jboolean JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1canConvert)
    (JNIEnv *env, jclass, jobject obj, jint type)
{
    QVariant v = qtjambi_to_qvariant(env, obj);
    return v.canConvert(QVariant::Type(type));
}

static inline void setOk(JNIEnv *env, jobjectArray ok, bool isOk)
{
    if (!env->IsSameObject(ok, 0) && env->GetArrayLength(ok)) {
        StaticCache *sc = StaticCache::instance();
        sc->resolveBoolean();
        jfieldID fieldId = isOk ? sc->Boolean.field_TRUE : sc->Boolean.field_FALSE;
        jobject boolObject = env->GetStaticObjectField(sc->Boolean.class_ref, fieldId);
        env->SetObjectArrayElement(ok, 0, boolObject);
    }
}

extern "C" Q_DECL_EXPORT jdouble JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toDouble)
    (JNIEnv *env, jclass, jobject object, jobjectArray ok)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    bool isOk = false;
    double returned = v.toDouble(&isOk);
    setOk(env, ok, isOk);
    return returned;
}

extern "C" Q_DECL_EXPORT jint JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toInt)
    (JNIEnv *env, jclass, jobject object, jobjectArray ok)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    bool isOk = false;
    int returned = v.toInt(&isOk);
    setOk(env, ok, isOk);
    return returned;
}

extern "C" Q_DECL_EXPORT jlong JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toLong)
    (JNIEnv *env, jclass, jobject object, jobjectArray ok)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    bool isOk = false;
    qlonglong returned = v.toLongLong(&isOk);
    setOk(env, ok, isOk);
    return returned;
}

extern "C" Q_DECL_EXPORT jobject JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toString)
    (JNIEnv *env, jclass, jobject object)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    return qtjambi_from_qstring(env, v.toString());
}

extern "C" Q_DECL_EXPORT jboolean JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toBoolean)
    (JNIEnv *env, jclass, jobject object)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    return v.toBool();
}

extern "C" Q_DECL_EXPORT jchar JNICALL
QTJAMBI_FUNCTION_PREFIX(Java_com_trolltech_qt_QVariant__1_1qt_1toChar)
    (JNIEnv *env, jclass, jobject object)
{
    QVariant v = qtjambi_to_qvariant(env, object);
    QChar c = v.toChar();
    return c.unicode();
}
