/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GENERATOR_SET_JAVA_H
#define GENERATOR_SET_JAVA_H

#include "generatorset.h"
#include "metajavabuilder.h"

class GeneratorSetJava : public GeneratorSet
{
    Q_OBJECT

public:
    GeneratorSetJava();

    QString usage();
    bool readParameters(const QMap<QString, QString> args);

    void buildModel(const QString pp_file);
    void dumpObjectTree();

    QString generate();

private:

    bool no_java;
    bool no_cpp_h;
    bool no_cpp_impl;
    bool no_metainfo;
    bool build_class_list;
    bool build_qdoc_japi;
    bool docs_enabled;
    bool do_ui_convert;
    bool native_jump_table;

    QString doc_dir;
    QString ui_file_name;
    QString custom_widgets;

    MetaJavaBuilder builder;

};

#endif // GENERATOR_SET_JAVA_H
