/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#ifndef JAMBI_CUSTOM_WIDGET_H
#define JAMBI_CUSTOM_WIDGET_H

#include <QtDesigner/QtDesigner>
#include <qtjambi_global.h>

class JambiCustomWidget: public QObject, public QDesignerCustomWidgetInterface
{
    Q_OBJECT
    Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
    JambiCustomWidget(jobject object);
    virtual ~JambiCustomWidget();

    virtual bool isInitialized() const;
    virtual void initialize(QDesignerFormEditorInterface *core);

    virtual QWidget *createWidget(QWidget *parent);

    virtual bool isContainer() const;
    virtual QString group() const;
    virtual QString name() const;
    virtual QString toolTip() const;
    virtual QString whatsThis() const;
    virtual QString includeFile() const;
    virtual QIcon icon() const;

    virtual QString domXml() const;


    QDesignerLanguageExtension *language() const;

private:
    QString callStringMethod(jmethodID method) const;

    QDesignerFormEditorInterface *m_core;
    jobject m_object;


};


class JambiCustomWidgetCollection : public QObject, public QDesignerCustomWidgetCollectionInterface
{
    Q_OBJECT
    Q_INTERFACES(QDesignerCustomWidgetCollectionInterface)

public:
    JambiCustomWidgetCollection();
    ~JambiCustomWidgetCollection();

    QList<QDesignerCustomWidgetInterface*> customWidgets() const;

public slots:
    void loadPlugins(const QString &path, QObject *widgetFactory);

private:
    void initializeWidgets(JNIEnv *env);

    jobject m_manager;
    jmethodID m_id_customWidgets;
    jmethodID m_id_loadPlugins;

    QList<QDesignerCustomWidgetInterface *> m_widgets;
};
#endif // JAMBI_CUSTOM_WIDGET_H
