/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt.gui;

import java.lang.reflect.Method;

import com.trolltech.qt.QNoNativeResourcesException;
import com.trolltech.qt.core.QByteArray;

// Not actually generated, but just to make sure not all
// virtual calls go through Java
@com.trolltech.qt.QtJambiGeneratedClass
public class QItemEditorCreator extends QItemEditorCreatorBase {

    public QItemEditorCreator(String valuePropertyName, Class<? extends QWidget> widgetType) {
        super((QPrivateConstructor) null);

        boolean createWidgetOverride = false;
        boolean valuePropertyNameOverride = false;
        try {
            Method createWidgetMethod = getClass().getMethod("createWidget", QWidget.class);
            Method valuePropertyNameMethod = getClass().getMethod("valuePropertyName");

            createWidgetOverride = com.trolltech.qt.internal.QtJambiInternal.isImplementedInJava(createWidgetMethod);
            valuePropertyNameOverride = com.trolltech.qt.internal.QtJambiInternal.isImplementedInJava(valuePropertyNameMethod);
        } catch (Throwable t) {
            throw new RuntimeException("Cannot construct QItemEditorCreator", t);
        }

        QByteArray valuePropertyNameByteArray = new QByteArray(valuePropertyName);
        __qt_QItemEditorCreator(valuePropertyNameByteArray.nativeId(), widgetType,
                createWidgetOverride, valuePropertyNameOverride);
    }
    private native void __qt_QItemEditorCreator(long valuePropertyNameId, Class<? extends QWidget> widgetType, boolean createWidgetOverride, boolean valuePropertyNameOverride);

    @Override
    public QWidget createWidget(QWidget parent) {
        if (nativeId() == 0)
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " +getClass().getName());
        return __qt_createWidget(nativeId(), parent.nativeId());
    }
    private native QWidget __qt_createWidget(long nativeId, long parentId);

    @Override
    public QByteArray valuePropertyName() {
        if (nativeId() == 0)
            throw new QNoNativeResourcesException("Function call on incomplete object of type: " +getClass().getName());
        return valuePropertyName(nativeId());
    }
    private native QByteArray valuePropertyName(long nativeId);

}
