/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt.core;

import com.trolltech.qt.gui.QApplication;

/**
 * The QSynchronousInvokable class is used internally by QCoreApplication.invokeLaterAndWait()
 * to synchronously execute a java.lang.Runnable from the gui-thread.
 *
 * @author eskil
 * @see QCoreApplication
 */
class QSynchronousInvokable extends QObject {
    static QEvent.Type SYNCHRONOUS_INVOKABLE_EVENT = QEvent.Type.resolve(QEvent.Type.User.value() + 1);

    private Runnable runnable;
    public QSynchronousInvokable(Runnable runnable) {
        disableGarbageCollection();
        if(QCoreApplication.instance().nativeId() != 0) {
            moveToThread(QCoreApplication.instance().thread());
            this.runnable = runnable;
        }

        if (runnable == null || Thread.currentThread().equals(QApplication.instance().thread()))
            invoked = true;

    }

    private Boolean invoked = false;
    synchronized void waitForInvoked() {
        while (!invoked) {
            try {
                wait();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        invoked = false;
    }

    @Override
    public final boolean event(com.trolltech.qt.core.QEvent e) {
        if (e.type() == SYNCHRONOUS_INVOKABLE_EVENT && runnable != null) {
            runnable.run();
            synchronized (this) {
                invoked = true;
                notifyAll();
            }
            return true;
        }
        return super.event(e);
    }
}
