/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * Information about a property in a QObject subclass.
 */
public class QtProperty {
    private final boolean writable;
    private final boolean designable;
    private final boolean resettable;
    private final boolean user;
    private final String name;

    QtProperty(boolean writable, boolean designable, boolean resettable, boolean user, String name) {
        this.writable = writable;
        this.designable = designable;
        this.resettable = resettable;
        this.user = user;
        this.name = name;
    }

    public final boolean isWritable() { return writable; }
    public final boolean isResettable() { return resettable; }
    public final boolean isDesignable() { return designable; }
    public final boolean isUser() { return user; }
    public final String name() { return name; }

    @Override
    public final String toString() {
        return name;
    }
}
