/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef JAMBIPROPERTYSHEET_H
#define JAMBIPROPERTYSHEET_H

#include <QtCore/QVariant>
#include <QtDesigner/QtDesigner>

class JambiLanguagePlugin;

class JambiPropertySheet: public QObject, public QDesignerPropertySheetExtension
{
    Q_OBJECT
    Q_INTERFACES(QDesignerPropertySheetExtension)
public:
    JambiPropertySheet(QObject *parent);

    // Reimplement property/setProperty to do enum/flags magic and force
    // user to reimplement read/write instead...
    virtual QVariant property(int index) const;
    virtual void setProperty(int index, const QVariant &value);

    virtual QVariant readProperty(int index) const = 0;
    virtual void writeProperty(int index, const QVariant &value) = 0;

};

#endif
